/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.LogicType;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.QueryLike;
import cool.scx.data.query.QueryOption;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereType;
import java.util.ArrayList;
import java.util.List;

public class Logic
extends QueryLike<Logic> {
    private final LogicType logicType;
    private final List<Object> clauses;

    public Logic(LogicType logicType) {
        this.logicType = logicType;
        this.clauses = new ArrayList<Object>();
    }

    public LogicType logicType() {
        return this.logicType;
    }

    public Object[] clauses() {
        return this.clauses.toArray();
    }

    public Logic add(Object ... logicCauses) {
        for (Object logicCause : logicCauses) {
            Where w;
            if (logicCause == null) continue;
            if (logicCause instanceof Object[]) {
                Object[] objs = (Object[])logicCause;
                this.add(objs);
                continue;
            }
            if (logicCause instanceof Where && (w = (Where)logicCause).info().replace()) {
                this.clauses.removeIf(c -> {
                    Where w1;
                    return c instanceof Where && (w1 = (Where)c).name().equals(w.name());
                });
            }
            this.clauses.add(logicCause);
        }
        return this;
    }

    public Logic clear() {
        this.clauses.clear();
        return this;
    }

    public final Logic eq(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.EQUAL, value, null, options));
    }

    public final Logic ne(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_EQUAL, value, null, options));
    }

    public final Logic lt(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.LESS_THAN, value, null, options));
    }

    public final Logic le(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.LESS_THAN_OR_EQUAL, value, null, options));
    }

    public final Logic gt(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.GREATER_THAN, value, null, options));
    }

    public final Logic ge(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.GREATER_THAN_OR_EQUAL, value, null, options));
    }

    public final Logic isNull(String fieldName, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.IS_NULL, null, null, options));
    }

    public final Logic isNotNull(String fieldName, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.IS_NOT_NULL, null, null, options));
    }

    public final Logic like(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.LIKE, value, null, options));
    }

    public final Logic notLike(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_LIKE, value, null, options));
    }

    public final Logic likeRegex(String fieldName, String value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.LIKE_REGEX, (Object)value, null, options));
    }

    public final Logic notLikeRegex(String fieldName, String value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_LIKE_REGEX, (Object)value, null, options));
    }

    public final Logic in(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.IN, value, null, options));
    }

    public final Logic notIn(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_IN, value, null, options));
    }

    public final Logic between(String fieldName, Object value1, Object value2, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.BETWEEN, value1, value2, options));
    }

    public final Logic notBetween(String fieldName, Object value1, Object value2, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_BETWEEN, value1, value2, options));
    }

    public final Logic jsonContains(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.JSON_CONTAINS, value, null, options));
    }

    @Override
    protected Query toQuery() {
        return new QueryImpl().where(this);
    }
}

