/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.parser;

import cool.scx.data.query.Logic;
import cool.scx.data.query.LogicType;
import cool.scx.data.query.Query;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.WhereType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public abstract class WhereParser {
    public WhereClause parse(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, WhereClause.class, Logic.class, Where.class, Query.class, Object[].class}, (Object)object2, n)) {
            case 0 -> {
                String s = (String)object2;
                yield this.parseString(s);
            }
            case 1 -> {
                WhereClause w = (WhereClause)object2;
                yield this.parseWhereClause(w);
            }
            case 2 -> {
                Logic l = (Logic)object2;
                yield this.parseLogic(l);
            }
            case 3 -> {
                Where w = (Where)object2;
                yield this.parseWhere(w);
            }
            case 4 -> {
                Query q = (Query)object2;
                yield this.parseQuery(q);
            }
            case 5 -> {
                Object[] o = (Object[])object2;
                yield this.parseAll(o);
            }
            default -> null;
        };
    }

    protected final WhereClause parseString(String s) {
        return new WhereClause(s, new Object[0]);
    }

    protected WhereClause parseWhereClause(WhereClause w) {
        return w;
    }

    protected final WhereClause parseLogic(Logic l) {
        ArrayList<String> clauses = new ArrayList<String>();
        ArrayList whereParams = new ArrayList();
        for (Object c : l.clauses()) {
            WhereClause w = this.parse(c);
            if (w == null || w.isEmpty()) continue;
            clauses.add(w.whereClause());
            Collections.addAll(whereParams, w.params());
        }
        Object clause = String.join((CharSequence)(" " + this.getLogicKeyWord(l.logicType()) + " "), clauses);
        if (clauses.size() > 1) {
            clause = "(" + (String)clause + ")";
        }
        return new WhereClause((String)clause, whereParams.toArray());
    }

    protected String getLogicKeyWord(LogicType logicType) {
        return switch (logicType) {
            default -> throw new MatchException(null, null);
            case LogicType.OR -> "OR";
            case LogicType.AND -> "AND";
        };
    }

    protected WhereClause parseWhere(Where body) {
        return switch (body.whereType()) {
            default -> throw new MatchException(null, null);
            case WhereType.IS_NULL, WhereType.IS_NOT_NULL -> this.parseIsNull(body);
            case WhereType.EQUAL, WhereType.NOT_EQUAL, WhereType.LESS_THAN, WhereType.LESS_THAN_OR_EQUAL, WhereType.GREATER_THAN, WhereType.GREATER_THAN_OR_EQUAL, WhereType.LIKE_REGEX, WhereType.NOT_LIKE_REGEX -> this.parseEqual(body);
            case WhereType.LIKE, WhereType.NOT_LIKE -> this.parseLike(body);
            case WhereType.IN, WhereType.NOT_IN -> this.parseIn(body);
            case WhereType.BETWEEN, WhereType.NOT_BETWEEN -> this.parseBetween(body);
            case WhereType.JSON_CONTAINS -> this.parseJsonContains(body);
        };
    }

    protected abstract WhereClause parseIsNull(Where var1);

    protected abstract WhereClause parseEqual(Where var1);

    protected abstract WhereClause parseLike(Where var1);

    protected abstract WhereClause parseIn(Where var1);

    protected abstract WhereClause parseBetween(Where var1);

    protected abstract WhereClause parseJsonContains(Where var1);

    protected WhereClause parseQuery(Query query) {
        return this.parseAll(query.getWhere());
    }

    protected final WhereClause parseAll(Object[] objs) {
        StringBuilder whereClause = new StringBuilder();
        ArrayList whereParams = new ArrayList();
        for (Object obj : objs) {
            WhereClause w = this.parse(obj);
            if (w == null || w.isEmpty()) continue;
            whereClause.append(w.whereClause());
            Collections.addAll(whereParams, w.params());
        }
        return new WhereClause(whereClause.toString(), whereParams.toArray());
    }

    public String getWhereKeyWord(WhereType whereType) {
        return switch (whereType) {
            default -> throw new MatchException(null, null);
            case WhereType.IS_NULL -> "IS NULL";
            case WhereType.IS_NOT_NULL -> "IS NOT NULL";
            case WhereType.EQUAL -> "=";
            case WhereType.NOT_EQUAL -> "<>";
            case WhereType.LESS_THAN -> "<";
            case WhereType.LESS_THAN_OR_EQUAL -> "<=";
            case WhereType.GREATER_THAN -> ">";
            case WhereType.GREATER_THAN_OR_EQUAL -> ">=";
            case WhereType.LIKE_REGEX, WhereType.LIKE -> "LIKE";
            case WhereType.NOT_LIKE_REGEX, WhereType.NOT_LIKE -> "NOT LIKE";
            case WhereType.IN -> "IN";
            case WhereType.NOT_IN -> "NOT IN";
            case WhereType.BETWEEN -> "BETWEEN";
            case WhereType.NOT_BETWEEN -> "NOT BETWEEN";
            case WhereType.JSON_CONTAINS -> "JSON_CONTAINS";
        };
    }
}

