/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.field_filter;

import cool.scx.data.field_filter.FieldFilter;
import cool.scx.data.field_filter.FilterMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class FieldFilterImpl
implements FieldFilter {
    private final FilterMode filterMode;
    private final Set<String> fieldNames;
    private boolean ignoreNullValue;

    public FieldFilterImpl(FilterMode filterMode) {
        this.filterMode = filterMode;
        this.fieldNames = new HashSet<String>();
        this.ignoreNullValue = true;
    }

    @Override
    public FieldFilter addIncluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.INCLUDED -> this.addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this.removeFieldNames(fieldNames);
        };
    }

    @Override
    public FieldFilter addExcluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.EXCLUDED -> this.addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this.removeFieldNames(fieldNames);
        };
    }

    @Override
    public FieldFilter removeIncluded(String ... fieldNames) {
        return this.addExcluded(fieldNames);
    }

    @Override
    public FieldFilter removeExcluded(String ... fieldNames) {
        return this.addIncluded(fieldNames);
    }

    @Override
    public FieldFilter ignoreNullValue(boolean ignoreNullValue) {
        this.ignoreNullValue = ignoreNullValue;
        return this;
    }

    @Override
    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public String[] getFieldNames() {
        return (String[])this.fieldNames.toArray(String[]::new);
    }

    @Override
    public boolean getIgnoreNullValue() {
        return this.ignoreNullValue;
    }

    @Override
    public FieldFilter clear() {
        this.fieldNames.clear();
        return this;
    }

    public FieldFilter addFieldNames(String ... fieldNames) {
        Collections.addAll(this.fieldNames, fieldNames);
        return this;
    }

    public FieldFilter removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this;
    }
}

