/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.query.Logic;
import cool.scx.data.query.LogicType;
import cool.scx.data.query.QueryOption;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.WhereType;
import java.util.ArrayList;

public class WhereDeserializer {
    public Object deserialize(JsonNode v) {
        if (v.isObject()) {
            String type;
            return switch (type = v.get("@type").asText()) {
                case "Logic" -> this.deserializeLogic(v);
                case "WhereClause" -> this.deserializeWhereClause(v);
                case "Where" -> this.deserializeWhere(v);
                default -> v;
            };
        }
        if (v.isTextual()) {
            return this.deserializeString(v);
        }
        if (v.isArray()) {
            return this.deserializeAll(v);
        }
        return null;
    }

    private Logic deserializeLogic(JsonNode v) {
        LogicType logicType = (LogicType)((Object)ObjectUtils.convertValue((Object)v.get("logicType"), LogicType.class));
        Object[] clauses = this.deserializeAll(v.get("clauses"));
        return new Logic(logicType).add(clauses);
    }

    private WhereClause deserializeWhereClause(JsonNode v) {
        String whereClause = v.get("whereClause").asText();
        Object[] params = (Object[])ObjectUtils.convertValue((Object)v.get("params"), Object[].class);
        return new WhereClause(whereClause, params);
    }

    private Where deserializeWhere(JsonNode v) {
        String name = v.get("name").asText();
        WhereType whereType = (WhereType)((Object)ObjectUtils.convertValue((Object)v.get("whereType"), WhereType.class));
        Object value1 = ObjectUtils.convertValue((Object)v.get("value1"), Object.class);
        Object value2 = ObjectUtils.convertValue((Object)v.get("value2"), Object.class);
        QueryOption.Info info = (QueryOption.Info)ObjectUtils.convertValue((Object)v.get("info"), QueryOption.Info.class);
        return new Where(name, whereType, value1, value2, info);
    }

    private String deserializeString(JsonNode v) {
        return v.textValue();
    }

    private Object[] deserializeAll(JsonNode v) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (JsonNode jsonNode : v) {
            s.add(this.deserialize(jsonNode));
        }
        return s.toArray();
    }
}

