/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data;

import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyBuilder;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryBuilder;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;

public interface Repository<Entity, ID> {
    public ID add(Entity var1, FieldPolicy var2);

    public List<ID> add(Collection<Entity> var1, FieldPolicy var2);

    public List<Entity> find(Query var1, FieldPolicy var2);

    public void find(Query var1, FieldPolicy var2, Consumer<Entity> var3);

    public Entity get(Query var1, FieldPolicy var2);

    public <T> List<T> findAs(Class<T> var1, Query var2, FieldPolicy var3);

    public <T> void findAs(Class<T> var1, Query var2, FieldPolicy var3, Consumer<T> var4);

    public <T> T getAs(Class<T> var1, Query var2, FieldPolicy var3);

    public long update(Entity var1, Query var2, FieldPolicy var3);

    public long delete(Query var1);

    public long count(Query var1);

    public void clear();

    default public ID add(Entity entity) {
        return this.add(entity, FieldPolicyBuilder.includedAll());
    }

    default public ID add(FieldPolicy fieldPolicy) {
        return this.add((Entity)null, fieldPolicy);
    }

    default public List<ID> add(Collection<Entity> entityList) {
        return this.add(entityList, FieldPolicyBuilder.includedAll());
    }

    default public List<Entity> find(Query query) {
        return this.find(query, FieldPolicyBuilder.includedAll());
    }

    default public List<Entity> find(FieldPolicy fieldFilter) {
        return this.find(QueryBuilder.query(), fieldFilter);
    }

    default public List<Entity> find() {
        return this.find(QueryBuilder.query(), FieldPolicyBuilder.includedAll());
    }

    default public void find(Query query, Consumer<Entity> entityConsumer) {
        this.find(query, FieldPolicyBuilder.includedAll(), entityConsumer);
    }

    default public void find(FieldPolicy fieldFilter, Consumer<Entity> entityConsumer) {
        this.find(QueryBuilder.query(), fieldFilter, entityConsumer);
    }

    default public void find(Consumer<Entity> entityConsumer) {
        this.find(QueryBuilder.query(), FieldPolicyBuilder.includedAll(), entityConsumer);
    }

    default public Entity get(Query query) {
        return this.get(query, FieldPolicyBuilder.includedAll());
    }

    default public <T> List<T> findAs(Class<T> resultClass, Query query) {
        return this.findAs(resultClass, query, FieldPolicyBuilder.includedAll());
    }

    default public <T> List<T> findAs(Class<T> resultClass, FieldPolicy fieldFilter) {
        return this.findAs(resultClass, QueryBuilder.query(), fieldFilter);
    }

    default public <T> List<T> findAs(Class<T> resultClass) {
        return this.findAs(resultClass, QueryBuilder.query(), FieldPolicyBuilder.includedAll());
    }

    default public <T> void findAs(Class<T> resultClass, Query query, Consumer<T> entityConsumer) {
        this.findAs(resultClass, query, FieldPolicyBuilder.includedAll(), entityConsumer);
    }

    default public <T> void findAs(Class<T> resultClass, FieldPolicy fieldFilter, Consumer<T> entityConsumer) {
        this.findAs(resultClass, QueryBuilder.query(), fieldFilter, entityConsumer);
    }

    default public <T> void findAs(Class<T> resultClass, Consumer<T> entityConsumer) {
        this.findAs(resultClass, QueryBuilder.query(), FieldPolicyBuilder.includedAll(), entityConsumer);
    }

    default public <T> T getAs(Class<T> resultClass, Query query) {
        return this.getAs(resultClass, query, FieldPolicyBuilder.includedAll());
    }

    default public long update(Entity entity, Query query) {
        return this.update(entity, query, FieldPolicyBuilder.includedAll());
    }

    default public long update(Query query, FieldPolicy fieldPolicy) {
        return this.update(null, query, fieldPolicy);
    }

    default public long count() {
        return this.count(QueryBuilder.query());
    }
}

