/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.field_policy;

import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FilterMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class FieldPolicyImpl
implements FieldPolicy {
    private final FilterMode filterMode;
    private final Set<String> fieldNames;
    private final Map<String, String> fieldExpressions;
    private boolean ignoreNullValue;

    public FieldPolicyImpl(FilterMode filterMode) {
        this.filterMode = filterMode;
        this.fieldNames = new HashSet<String>();
        this.fieldExpressions = new LinkedHashMap<String, String>();
        this.ignoreNullValue = true;
    }

    @Override
    public FieldPolicy included(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.INCLUDED -> this.addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this.removeFieldNames(fieldNames);
        };
    }

    @Override
    public FieldPolicy excluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.EXCLUDED -> this.addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this.removeFieldNames(fieldNames);
        };
    }

    @Override
    public FilterMode filterMode() {
        return this.filterMode;
    }

    @Override
    public String[] fieldNames() {
        return (String[])this.fieldNames.toArray(String[]::new);
    }

    @Override
    public FieldPolicy clearFieldNames() {
        this.fieldNames.clear();
        return this;
    }

    @Override
    public FieldPolicy ignoreNullValue(boolean ignoreNullValue) {
        this.ignoreNullValue = ignoreNullValue;
        return this;
    }

    @Override
    public boolean ignoreNullValue() {
        return this.ignoreNullValue;
    }

    @Override
    public FieldPolicy fieldExpression(String fieldName, String expression) {
        this.fieldExpressions.put(fieldName, expression);
        return this;
    }

    @Override
    public Map<String, String> fieldExpressions() {
        return this.fieldExpressions;
    }

    @Override
    public FieldPolicy clearFieldExpressions() {
        this.fieldExpressions.clear();
        return this;
    }

    public FieldPolicy addFieldNames(String ... fieldNames) {
        Collections.addAll(this.fieldNames, fieldNames);
        return this;
    }

    public FieldPolicy removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this;
    }
}

