/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.field_policy.serializer;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyImpl;
import cool.scx.data.field_policy.FilterMode;
import java.util.Map;

public class FieldPolicyDeserializer {
    public static final FieldPolicyDeserializer FIELD_POLICY_DESERIALIZER = new FieldPolicyDeserializer();

    public Object deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("FieldFilter")) {
            return this.deserializeFieldFilter(v);
        }
        return v;
    }

    public FieldPolicy deserializeFieldFilter(JsonNode objectNode) {
        FilterMode filterMode = FilterMode.EXCLUDED;
        if (objectNode == null) {
            return new FieldPolicyImpl(filterMode);
        }
        if (objectNode.get("filterMode") != null && !objectNode.get("filterMode").isNull()) {
            filterMode = (FilterMode)((Object)ObjectUtils.convertValue((Object)objectNode.get("filterMode"), FilterMode.class));
        }
        FieldPolicyImpl fieldFilter = new FieldPolicyImpl(filterMode);
        if (objectNode.get("fieldNames") != null && !objectNode.get("fieldNames").isNull()) {
            String[] fieldNames = (String[])ObjectUtils.convertValue((Object)objectNode.get("fieldNames"), String[].class);
            fieldFilter.addFieldNames(fieldNames);
        }
        if (objectNode.get("ignoreNullValue") != null && !objectNode.get("ignoreNullValue").isNull()) {
            boolean ignoreNullValue = objectNode.get("ignoreNullValue").asBoolean();
            fieldFilter.ignoreNullValue(ignoreNullValue);
        }
        if (objectNode.get("fieldExpressions") != null && !objectNode.get("fieldExpressions").isNull()) {
            Map fieldExpressions = (Map)ObjectUtils.convertValue((Object)objectNode.get("fieldExpressions"), (TypeReference)new TypeReference<Map<String, String>>(this){});
            for (Map.Entry entry : fieldExpressions.entrySet()) {
                fieldFilter.fieldExpression((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return fieldFilter;
    }
}

