/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data;

import cool.scx.data.Finder;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyBuilder;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryBuilder;
import java.util.Collection;
import java.util.List;

public interface Repository<Entity, ID> {
    public ID add(Entity var1, FieldPolicy var2);

    public List<ID> add(Collection<Entity> var1, FieldPolicy var2);

    public Finder<Entity> finder(Query var1, FieldPolicy var2);

    public long update(Entity var1, FieldPolicy var2, Query var3);

    public long delete(Query var1);

    public void clear();

    default public ID add(Entity entity) {
        return this.add(entity, FieldPolicyBuilder.includedAll());
    }

    default public ID add(FieldPolicy fieldPolicy) {
        return this.add((Entity)null, fieldPolicy);
    }

    default public List<ID> add(Collection<Entity> entityList) {
        return this.add(entityList, FieldPolicyBuilder.includedAll());
    }

    default public Finder<Entity> finder(Query query) {
        return this.finder(query, FieldPolicyBuilder.includedAll());
    }

    default public Finder<Entity> finder(FieldPolicy fieldPolicy) {
        return this.finder(QueryBuilder.query(), fieldPolicy);
    }

    default public Finder<Entity> finder() {
        return this.finder(QueryBuilder.query(), FieldPolicyBuilder.includedAll());
    }

    default public List<Entity> find(Query query, FieldPolicy fieldPolicy) {
        return this.finder(query, fieldPolicy).list();
    }

    default public List<Entity> find(Query query) {
        return this.finder(query).list();
    }

    default public List<Entity> find(FieldPolicy fieldPolicy) {
        return this.finder(fieldPolicy).list();
    }

    default public List<Entity> find() {
        return this.finder().list();
    }

    default public Entity get(Query query, FieldPolicy fieldPolicy) {
        return this.finder(query, fieldPolicy).first();
    }

    default public Entity get(Query query) {
        return this.finder(query).first();
    }

    default public long update(Entity entity, Query query) {
        return this.update(entity, FieldPolicyBuilder.includedAll(), query);
    }

    default public long update(FieldPolicy fieldPolicy, Query query) {
        return this.update(null, fieldPolicy, query);
    }

    default public long count(Query query) {
        return this.finder(query).count();
    }

    default public long count() {
        return this.finder().count();
    }
}

