/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.serializer.GroupByDeserializer;
import cool.scx.data.query.serializer.OrderByDeserializer;
import cool.scx.data.query.serializer.WhereDeserializer;

public class QueryDeserializer {
    public static final QueryDeserializer QUERY_DESERIALIZER = new QueryDeserializer();
    private final WhereDeserializer whereDeserializer = new WhereDeserializer();
    private final GroupByDeserializer groupByDeserializer = new GroupByDeserializer();
    private final OrderByDeserializer orderByDeserializer = new OrderByDeserializer();

    public Query fromJson(String json) throws JsonProcessingException {
        JsonNode v = ObjectUtils.jsonMapper().readTree(json);
        return this.deserializeQuery(v);
    }

    public Object deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("Query")) {
            return this.deserializeQuery(v);
        }
        return null;
    }

    public Query deserializeQuery(JsonNode objectNode) {
        QueryImpl query = new QueryImpl();
        if (objectNode == null) {
            return query;
        }
        if (objectNode.get("where") != null && !objectNode.get("where").isNull()) {
            Object where = this.whereDeserializer.deserialize(objectNode.get("where"));
            query.where(where);
        }
        if (objectNode.get("groupBy") != null && !objectNode.get("groupBy").isNull()) {
            Object groupBy = this.groupByDeserializer.deserialize(objectNode.path("groupBy"));
            query.groupBy(groupBy);
        }
        if (objectNode.get("orderBy") != null && !objectNode.get("orderBy").isNull()) {
            Object orderBy = this.orderByDeserializer.deserialize(objectNode.path("orderBy"));
            query.orderBy(orderBy);
        }
        if (objectNode.get("offset") != null && !objectNode.get("offset").isNull()) {
            query.offset(objectNode.get("offset").asLong());
        }
        if (objectNode.get("limit") != null && !objectNode.get("limit").isNull()) {
            query.limit(objectNode.get("limit").asLong());
        }
        return query;
    }
}

