/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.query.Query;
import cool.scx.data.query.serializer.GroupBySerializer;
import cool.scx.data.query.serializer.OrderBySerializer;
import cool.scx.data.query.serializer.WhereSerializer;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.Objects;

public class QuerySerializer {
    public static final QuerySerializer QUERY_SERIALIZER = new QuerySerializer();
    private final WhereSerializer whereSerializer = new WhereSerializer();
    private final GroupBySerializer groupBySerializer = new GroupBySerializer();
    private final OrderBySerializer orderBySerializer = new OrderBySerializer();

    public String toJson(Query query) throws JsonProcessingException {
        Object v = this.serialize(query);
        return ObjectUtils.jsonMapper().writeValueAsString(v);
    }

    public Object serialize(Object obj) {
        Object object = obj;
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Query.class}, (Object)object2, n)) {
            case 0 -> {
                Query s = (Query)object2;
                yield this.serializeQuery(s);
            }
            default -> obj;
        };
    }

    private Object serializeQuery(Query query) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Query");
        m.put("where", this.whereSerializer.serialize(query));
        m.put("groupBy", this.groupBySerializer.serialize(query));
        m.put("orderBy", this.orderBySerializer.serialize(query));
        m.put("offset", query.getOffset());
        m.put("limit", query.getLimit());
        return m;
    }
}

