/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.field_policy;

import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FilterMode;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public final class FieldPolicyImpl
implements FieldPolicy {
    private final FilterMode filterMode;
    private final Set<String> fieldNames;
    private final Map<String, String> expressions;
    private final Map<String, Boolean> ignoreNulls;
    private boolean ignoreNull;

    public FieldPolicyImpl(FilterMode filterMode) {
        this.filterMode = filterMode;
        this.fieldNames = new HashSet<String>();
        this.expressions = new LinkedHashMap<String, String>();
        this.ignoreNulls = new LinkedHashMap<String, Boolean>();
        this.ignoreNull = true;
    }

    @Override
    public FieldPolicy included(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.INCLUDED -> this.addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this.removeFieldNames(fieldNames);
        };
    }

    @Override
    public FieldPolicy excluded(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.EXCLUDED -> this.addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this.removeFieldNames(fieldNames);
        };
    }

    @Override
    public FilterMode filterMode() {
        return this.filterMode;
    }

    @Override
    public String[] fieldNames() {
        return (String[])this.fieldNames.toArray(String[]::new);
    }

    @Override
    public FieldPolicy clearFieldNames() {
        this.fieldNames.clear();
        return this;
    }

    @Override
    public FieldPolicy ignoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    @Override
    public boolean ignoreNull() {
        return this.ignoreNull;
    }

    @Override
    public FieldPolicy ignoreNull(String fieldName, boolean ignoreNull) {
        this.ignoreNulls.put(fieldName, ignoreNull);
        return this;
    }

    @Override
    public FieldPolicy removeIgnoreNull(String fieldName) {
        this.ignoreNulls.remove(fieldName);
        return this;
    }

    @Override
    public Map<String, Boolean> ignoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public FieldPolicy clearIgnoreNulls() {
        this.ignoreNulls.clear();
        return this;
    }

    @Override
    public FieldPolicy expression(String fieldName, String expression) {
        this.expressions.put(fieldName, expression);
        return this;
    }

    @Override
    public Map<String, String> expressions() {
        return this.expressions;
    }

    @Override
    public FieldPolicy removeExpression(String fieldName) {
        this.expressions.remove(fieldName);
        return this;
    }

    @Override
    public FieldPolicy clearExpressions() {
        this.expressions.clear();
        return this;
    }

    public FieldPolicy addFieldNames(String ... fieldNames) {
        Collections.addAll(this.fieldNames, fieldNames);
        return this;
    }

    public FieldPolicy removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this;
    }
}

