/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.serializer;

import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.query.GroupBy;
import cool.scx.data.query.QueryOption;
import java.util.ArrayList;

public class GroupByDeserializer {
    public Object deserialize(JsonNode v) {
        if (v.isObject()) {
            String type;
            return switch (type = v.get("@type").asText()) {
                case "GroupBy" -> this.deserializeGroupBy(v);
                default -> v;
            };
        }
        if (v.isTextual()) {
            return this.deserializeString(v);
        }
        if (v.isArray()) {
            return this.deserializeAll(v);
        }
        return null;
    }

    private GroupBy deserializeGroupBy(JsonNode v) {
        String name = v.path("name").asText();
        QueryOption.Info info = (QueryOption.Info)ObjectUtils.convertValue((Object)v.path("info"), QueryOption.Info.class);
        return new GroupBy(name, info);
    }

    private String deserializeString(JsonNode v) {
        return v.textValue();
    }

    private Object[] deserializeAll(JsonNode v) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (JsonNode jsonNode : v) {
            s.add(this.deserialize(jsonNode));
        }
        return s.toArray();
    }
}

