/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.And;
import cool.scx.data.query.Junction;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.QueryOption;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.WhereType;

public final class QueryBuilder {
    public static Query query() {
        return new QueryImpl();
    }

    public static Query query(Query oldQuery) {
        return new QueryImpl(oldQuery);
    }

    public static Query where(Object where) {
        return new QueryImpl().where(where);
    }

    public static Query groupBy(Object ... groupByClauses) {
        return new QueryImpl().groupBy(groupByClauses);
    }

    public static Query orderBy(Object ... orderByClauses) {
        return new QueryImpl().orderBy(orderByClauses);
    }

    public static Query offset(long offset) {
        return new QueryImpl().offset(offset);
    }

    public static Query limit(long limit) {
        return new QueryImpl().limit(limit);
    }

    public static Junction and(Object ... clauses) {
        return new And().add(clauses);
    }

    public static Junction or(Object ... clauses) {
        return new Or().add(clauses);
    }

    public static Not not(Object clause) {
        return new Not(clause);
    }

    public static OrderBy asc(String name, QueryOption ... options) {
        return new OrderBy(name, OrderByType.ASC, options);
    }

    public static OrderBy desc(String name, QueryOption ... options) {
        return new OrderBy(name, OrderByType.DESC, options);
    }

    public static Where eq(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.EQ, value, null, options);
    }

    public static Where ne(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.NE, value, null, options);
    }

    public static Where lt(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.LT, value, null, options);
    }

    public static Where lte(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.LTE, value, null, options);
    }

    public static Where gt(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.GT, value, null, options);
    }

    public static Where gte(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.GTE, value, null, options);
    }

    public static Where like(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.LIKE, value, null, options);
    }

    public static Where notLike(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.NOT_LIKE, value, null, options);
    }

    public static Where likeRegex(String fieldName, String value, QueryOption ... options) {
        return new Where(fieldName, WhereType.LIKE_REGEX, (Object)value, null, options);
    }

    public static Where notLikeRegex(String fieldName, String value, QueryOption ... options) {
        return new Where(fieldName, WhereType.NOT_LIKE_REGEX, (Object)value, null, options);
    }

    public static Where in(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.IN, value, null, options);
    }

    public static Where notIn(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.NOT_IN, value, null, options);
    }

    public static Where between(String fieldName, Object value1, Object value2, QueryOption ... options) {
        return new Where(fieldName, WhereType.BETWEEN, value1, value2, options);
    }

    public static Where notBetween(String fieldName, Object value1, Object value2, QueryOption ... options) {
        return new Where(fieldName, WhereType.NOT_BETWEEN, value1, value2, options);
    }

    public static Where jsonContains(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.JSON_CONTAINS, value, null, options);
    }

    public static Where jsonOverlaps(String fieldName, Object value, QueryOption ... options) {
        return new Where(fieldName, WhereType.JSON_OVERLAPS, value, null, options);
    }

    public static WhereClause whereClause(String whereClause, Object ... params) {
        return new WhereClause(whereClause, params);
    }
}

