/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.GroupBy;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.Query;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class QueryImpl
implements Query {
    private Object where = null;
    private final List<Object> groupBy = new ArrayList<Object>();
    private final List<Object> orderBy = new ArrayList<Object>();
    private Long offset = null;
    private Long limit = null;

    public QueryImpl() {
    }

    public QueryImpl(Query oldQuery) {
        this();
        this.where(oldQuery.getWhere());
        this.addGroupBy(oldQuery.getGroupBy());
        this.addOrderBy(oldQuery.getOrderBy());
        if (oldQuery.getOffset() != null) {
            this.offset(oldQuery.getOffset());
        }
        if (oldQuery.getLimit() != null) {
            this.limit(oldQuery.getLimit());
        }
    }

    @Override
    public QueryImpl where(Object where) {
        this.where = where;
        return this;
    }

    @Override
    public QueryImpl groupBy(Object ... groupByClauses) {
        this.clearGroupBy();
        this.addGroupBy(groupByClauses);
        return this;
    }

    @Override
    public QueryImpl orderBy(Object ... orderByClauses) {
        this.clearOrderBy();
        this.addOrderBy(orderByClauses);
        return this;
    }

    @Override
    public QueryImpl offset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Limit \u53c2\u6570\u9519\u8bef : offset (\u504f\u79fb\u91cf) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        this.offset = offset;
        return this;
    }

    @Override
    public QueryImpl limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit \u53c2\u6570\u9519\u8bef : limit (\u884c\u957f\u5ea6) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        this.limit = limit;
        return this;
    }

    @Override
    public Object getWhere() {
        return this.where;
    }

    @Override
    public Object[] getGroupBy() {
        return this.groupBy.toArray();
    }

    @Override
    public Object[] getOrderBy() {
        return this.orderBy.toArray();
    }

    @Override
    public Long getOffset() {
        return this.offset;
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    @Override
    public QueryImpl clearWhere() {
        this.where = null;
        return this;
    }

    @Override
    public QueryImpl clearGroupBy() {
        this.groupBy.clear();
        return this;
    }

    @Override
    public QueryImpl clearOrderBy() {
        this.orderBy.clear();
        return this;
    }

    @Override
    public QueryImpl clearOffset() {
        this.offset = null;
        return this;
    }

    @Override
    public QueryImpl clearLimit() {
        this.limit = null;
        return this;
    }

    @Override
    public QueryImpl addGroupBy(Object ... groupByClauses) {
        for (Object groupByClause : groupByClauses) {
            GroupBy w;
            if (groupByClause == null) continue;
            if (groupByClause instanceof Object[]) {
                Object[] objs = (Object[])groupByClause;
                this.addGroupBy(objs);
                continue;
            }
            if (groupByClause instanceof GroupBy && (w = (GroupBy)groupByClause).info().replace()) {
                this.groupBy.removeIf(c -> {
                    GroupBy w1;
                    return c instanceof GroupBy && (w1 = (GroupBy)c).name().equals(w.name());
                });
            }
            this.groupBy.add(groupByClause);
        }
        return this;
    }

    @Override
    public QueryImpl addOrderBy(Object ... orderByClauses) {
        for (Object orderByClause : orderByClauses) {
            OrderBy w;
            if (orderByClause == null) continue;
            if (orderByClause instanceof Object[]) {
                Object[] objs = (Object[])orderByClause;
                this.addOrderBy(objs);
                continue;
            }
            if (orderByClause instanceof OrderBy && (w = (OrderBy)orderByClause).info().replace()) {
                this.orderBy.removeIf(c -> {
                    OrderBy w1;
                    return c instanceof OrderBy && (w1 = (OrderBy)c).name().equals(w.name());
                });
            }
            this.orderBy.add(orderByClause);
        }
        return this;
    }

    @Override
    public Query removeGroupByIf(Predicate<Object> filter) {
        this.groupBy.removeIf(filter);
        return this;
    }

    @Override
    public Query removeOrderByIf(Predicate<Object> filter) {
        this.orderBy.removeIf(filter);
        return this;
    }
}

