/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.And;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.QueryLike;
import cool.scx.data.query.QueryOption;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereType;
import java.util.ArrayList;
import java.util.List;

public abstract sealed class Junction
extends QueryLike<Junction>
permits And, Or {
    private final List<Object> clauses = new ArrayList<Object>();

    protected Junction() {
    }

    public Object[] clauses() {
        return this.clauses.toArray();
    }

    public Junction add(Object ... logicCauses) {
        for (Object logicCause : logicCauses) {
            Where w;
            if (logicCause == null) continue;
            if (logicCause instanceof Object[]) {
                Object[] objs = (Object[])logicCause;
                this.add(objs);
                continue;
            }
            if (logicCause instanceof Where && (w = (Where)logicCause).info().replace()) {
                this.clauses.removeIf(c -> {
                    Where w1;
                    return c instanceof Where && (w1 = (Where)c).name().equals(w.name());
                });
            }
            this.clauses.add(logicCause);
        }
        return this;
    }

    public Junction clear() {
        this.clauses.clear();
        return this;
    }

    public final Junction eq(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.EQ, value, null, options));
    }

    public final Junction ne(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NE, value, null, options));
    }

    public final Junction lt(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.LT, value, null, options));
    }

    public final Junction lte(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.LTE, value, null, options));
    }

    public final Junction gt(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.GT, value, null, options));
    }

    public final Junction gte(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.GTE, value, null, options));
    }

    public final Junction like(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.LIKE, value, null, options));
    }

    public final Junction notLike(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_LIKE, value, null, options));
    }

    public final Junction likeRegex(String fieldName, String value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.LIKE_REGEX, (Object)value, null, options));
    }

    public final Junction notLikeRegex(String fieldName, String value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_LIKE_REGEX, (Object)value, null, options));
    }

    public final Junction in(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.IN, value, null, options));
    }

    public final Junction notIn(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_IN, value, null, options));
    }

    public final Junction between(String fieldName, Object value1, Object value2, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.BETWEEN, value1, value2, options));
    }

    public final Junction notBetween(String fieldName, Object value1, Object value2, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.NOT_BETWEEN, value1, value2, options));
    }

    public final Junction jsonContains(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.JSON_CONTAINS, value, null, options));
    }

    public final Junction jsonOverlaps(String fieldName, Object value, QueryOption ... options) {
        return this.add(new Where(fieldName, WhereType.JSON_OVERLAPS, value, null, options));
    }

    public final Junction and(Object ... clauses) {
        return this.add(new And().add(clauses));
    }

    public final Junction or(Object ... clauses) {
        return this.add(new Or().add(clauses));
    }

    public final Junction not(Object clause) {
        return this.add(new Not(clause));
    }

    @Override
    protected Query toQuery() {
        return new QueryImpl().where(this);
    }
}

