/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.parser;

import cool.scx.data.query.And;
import cool.scx.data.query.Junction;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.Query;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import cool.scx.data.query.WhereType;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;

public abstract class WhereParser {
    public WhereClause parse(Object obj) {
        Object object = obj;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, WhereClause.class, Junction.class, Not.class, Where.class, Query.class, Object[].class}, (Object)object, n)) {
            case 0 -> {
                String s = (String)object;
                yield this.parseString(s);
            }
            case 1 -> {
                WhereClause w = (WhereClause)object;
                yield this.parseWhereClause(w);
            }
            case 2 -> {
                Junction j = (Junction)object;
                yield this.parseJunction(j);
            }
            case 3 -> {
                Not n = (Not)object;
                yield this.parseNot(n);
            }
            case 4 -> {
                Where w = (Where)object;
                yield this.parseWhere(w);
            }
            case 5 -> {
                Query q = (Query)object;
                yield this.parseQuery(q);
            }
            case 6 -> {
                Object[] o = (Object[])object;
                yield this.parseAll(o);
            }
            case -1 -> new WhereClause(null, new Object[0]);
            default -> throw new IllegalArgumentException("Unsupported object type: " + String.valueOf(obj.getClass()));
        };
    }

    protected final WhereClause parseString(String s) {
        return new WhereClause("(" + s + ")", new Object[0]);
    }

    protected WhereClause parseWhereClause(WhereClause w) {
        return w;
    }

    protected final WhereClause parseJunction(Junction j) {
        ArrayList<String> clauses = new ArrayList<String>();
        ArrayList whereParams = new ArrayList();
        for (Object c : j.clauses()) {
            WhereClause w = this.parse(c);
            if (w == null || w.isEmpty()) continue;
            clauses.add(w.whereClause());
            Collections.addAll(whereParams, w.params());
        }
        if (clauses.isEmpty()) {
            return new WhereClause(null, new Object[0]);
        }
        Object clause = String.join((CharSequence)(" " + this.getJunctionKeyWord(j) + " "), clauses);
        if (clauses.size() > 1) {
            clause = "(" + (String)clause + ")";
        }
        return new WhereClause((String)clause, whereParams.toArray());
    }

    protected String getJunctionKeyWord(Junction junction) {
        Junction junction2 = junction;
        Objects.requireNonNull(junction2);
        Junction junction3 = junction2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Or.class, And.class}, (Junction)junction3, n)) {
            default -> throw new MatchException(null, null);
            case 0 -> "OR";
            case 1 -> "AND";
        };
    }

    protected WhereClause parseNot(Not n) {
        WhereClause w = this.parse(n.clause());
        if (w != null && !w.isEmpty()) {
            return new WhereClause(this.getNotKeyWord(n) + " " + w.whereClause(), w.params());
        }
        return new WhereClause(null, new Object[0]);
    }

    protected String getNotKeyWord(Not n) {
        return "NOT";
    }

    protected WhereClause parseQuery(Query query) {
        return this.parse(query.getWhere());
    }

    protected final WhereClause parseAll(Object[] objs) {
        ArrayList<String> clauses = new ArrayList<String>();
        ArrayList whereParams = new ArrayList();
        for (Object obj : objs) {
            WhereClause w = this.parse(obj);
            if (w == null || w.isEmpty()) continue;
            clauses.add(w.whereClause());
            Collections.addAll(whereParams, w.params());
        }
        if (clauses.isEmpty()) {
            return new WhereClause(null, new Object[0]);
        }
        return new WhereClause(String.join((CharSequence)"", clauses), whereParams.toArray());
    }

    protected WhereClause parseWhere(Where body) {
        return switch (body.whereType()) {
            default -> throw new MatchException(null, null);
            case WhereType.EQ -> this.parseEQ(body);
            case WhereType.NE -> this.parseNE(body);
            case WhereType.LT -> this.parseLT(body);
            case WhereType.LTE -> this.parseLTE(body);
            case WhereType.GT -> this.parseGT(body);
            case WhereType.GTE -> this.parseGTE(body);
            case WhereType.LIKE -> this.parseLIKE(body);
            case WhereType.NOT_LIKE -> this.parseNOT_LIKE(body);
            case WhereType.LIKE_REGEX -> this.parseLIKE_REGEX(body);
            case WhereType.NOT_LIKE_REGEX -> this.parseNOT_LIKE_REGEX(body);
            case WhereType.IN -> this.parseIN(body);
            case WhereType.NOT_IN -> this.parseNOT_IN(body);
            case WhereType.BETWEEN -> this.parseBETWEEN(body);
            case WhereType.NOT_BETWEEN -> this.parseNOT_BETWEEN(body);
            case WhereType.JSON_CONTAINS -> this.parseJSON_CONTAINS(body);
            case WhereType.JSON_OVERLAPS -> this.parseJSON_OVERLAPS(body);
        };
    }

    protected abstract WhereClause parseEQ(Where var1);

    protected abstract WhereClause parseNE(Where var1);

    protected abstract WhereClause parseLT(Where var1);

    protected abstract WhereClause parseLTE(Where var1);

    protected abstract WhereClause parseGT(Where var1);

    protected abstract WhereClause parseGTE(Where var1);

    protected abstract WhereClause parseLIKE(Where var1);

    protected abstract WhereClause parseNOT_LIKE(Where var1);

    protected abstract WhereClause parseLIKE_REGEX(Where var1);

    protected abstract WhereClause parseNOT_LIKE_REGEX(Where var1);

    protected abstract WhereClause parseIN(Where var1);

    protected abstract WhereClause parseNOT_IN(Where var1);

    protected abstract WhereClause parseBETWEEN(Where var1);

    protected abstract WhereClause parseNOT_BETWEEN(Where var1);

    protected abstract WhereClause parseJSON_CONTAINS(Where var1);

    protected abstract WhereClause parseJSON_OVERLAPS(Where var1);
}

