/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.aggregation.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.aggregation.Agg;
import cool.scx.data.aggregation.Aggregation;
import cool.scx.data.aggregation.AggregationImpl;
import cool.scx.data.aggregation.AggregationLike;
import cool.scx.data.aggregation.ExpressionGroupBy;
import cool.scx.data.aggregation.FieldGroupBy;
import cool.scx.data.aggregation.GroupBy;
import cool.scx.data.build_control.BuildControlInfo;
import java.util.ArrayList;

public class AggregationDeserializer {
    public static final AggregationDeserializer AGGREGATION_DEFINITION_DESERIALIZER = new AggregationDeserializer();

    public Aggregation fromJson(String json) throws JsonProcessingException {
        JsonNode v = ObjectUtils.jsonMapper().readTree(json);
        return this.deserialize(v);
    }

    public Aggregation deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("Aggregation")) {
            return this.deserializeAggregationDefinition(v);
        }
        throw new IllegalArgumentException("Invalid aggregation definition: " + String.valueOf(v));
    }

    public Aggregation deserializeAggregationDefinition(JsonNode objectNode) {
        ArrayList<AggregationLike> s;
        if (objectNode == null) {
            return new AggregationImpl();
        }
        AggregationImpl aggregationDefinition = new AggregationImpl();
        JsonNode groupBysNode = objectNode.get("groupBys");
        JsonNode aggsNode = objectNode.get("aggs");
        if (groupBysNode != null && !groupBysNode.isNull()) {
            s = new ArrayList<AggregationLike>();
            for (JsonNode groupByNode : groupBysNode) {
                s.add(this.deserializeGroupBy(groupByNode));
            }
            aggregationDefinition.groupBys((GroupBy[])s.toArray(GroupBy[]::new));
        }
        if (aggsNode != null && !aggsNode.isNull()) {
            s = new ArrayList();
            for (JsonNode aggNode : aggsNode) {
                s.add(this.deserializeAgg(aggNode));
            }
            aggregationDefinition.aggs((Agg[])s.toArray(Agg[]::new));
        }
        return aggregationDefinition;
    }

    public GroupBy deserializeGroupBy(JsonNode v) {
        if (v.isObject()) {
            String type = v.get("@type").asText();
            if (type.equals("FieldGroupBy")) {
                return this.deserializeFieldGroupBy(v);
            }
            if (type.equals("ExpressionGroupBy")) {
                return this.deserializeExpressionGroupBy(v);
            }
        }
        throw new IllegalArgumentException("Invalid Group By: " + String.valueOf(v));
    }

    private GroupBy deserializeFieldGroupBy(JsonNode v) {
        JsonNode fieldNameNode = v.path("fieldName");
        JsonNode infoNode = v.path("info");
        String fieldName = fieldNameNode.asText();
        BuildControlInfo info = (BuildControlInfo)ObjectUtils.convertValue((Object)infoNode, BuildControlInfo.class);
        return new FieldGroupBy(fieldName, info);
    }

    private GroupBy deserializeExpressionGroupBy(JsonNode v) {
        JsonNode aliasNode = v.path("alias");
        JsonNode expressionNode = v.path("expression");
        JsonNode infoNode = v.path("info");
        String alias = aliasNode.asText();
        String expression = expressionNode.asText();
        BuildControlInfo info = (BuildControlInfo)ObjectUtils.convertValue((Object)infoNode, BuildControlInfo.class);
        return new ExpressionGroupBy(alias, expression, info);
    }

    public Agg deserializeAgg(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("Agg")) {
            return this.deserializeAgg0(v);
        }
        throw new IllegalArgumentException("Invalid Group By: " + String.valueOf(v));
    }

    private Agg deserializeAgg0(JsonNode v) {
        JsonNode expressionNode = v.path("expression");
        JsonNode aliasNode = v.path("alias");
        JsonNode infoNode = v.path("info");
        String name = expressionNode.asText();
        String expression = aliasNode == null || aliasNode.isNull() ? null : aliasNode.asText();
        BuildControlInfo info = (BuildControlInfo)ObjectUtils.convertValue((Object)infoNode, BuildControlInfo.class);
        return new Agg(name, expression, info);
    }
}

