/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.field_policy.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.VirtualField;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class FieldPolicySerializer {
    public static final FieldPolicySerializer FIELD_POLICY_SERIALIZER = new FieldPolicySerializer();

    public String toJson(FieldPolicy fieldPolicy) throws JsonProcessingException {
        Map<String, Object> v = this.serialize(fieldPolicy);
        return ObjectUtils.jsonMapper().writeValueAsString(v);
    }

    public Map<String, Object> serializeVirtualField(VirtualField args) {
        LinkedHashMap<String, Object> s = new LinkedHashMap<String, Object>();
        s.put("@type", "VirtualField");
        s.put("expression", args.expression());
        s.put("virtualFieldName", args.virtualFieldName());
        return s;
    }

    public Map<String, Object> serialize(FieldPolicy fieldPolicy) {
        return this.serializeFieldPolicy(fieldPolicy);
    }

    private Map<String, Object> serializeFieldPolicy(FieldPolicy fieldPolicy) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "FieldPolicy");
        m.put("filterMode", (Object)fieldPolicy.getFilterMode());
        m.put("fieldNames", fieldPolicy.getFieldNames());
        m.put("virtualFields", this.serializeVirtualFields(fieldPolicy.getVirtualFields()));
        m.put("ignoreNull", fieldPolicy.getIgnoreNull());
        m.put("ignoreNulls", fieldPolicy.getIgnoreNulls());
        m.put("expressions", this.serializeExpressions(fieldPolicy.getAssignFields()));
        return m;
    }

    public ArrayList<Object> serializeVirtualFields(VirtualField ... virtualFields) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (VirtualField virtualField : virtualFields) {
            s.add(this.serializeVirtualField(virtualField));
        }
        return s;
    }

    public ArrayList<Object> serializeExpressions(AssignField ... expressions) {
        ArrayList<Object> s = new ArrayList<Object>();
        for (AssignField expression : expressions) {
            s.add(this.serializeExpression(expression));
        }
        return s;
    }

    public Map<String, Object> serializeExpression(AssignField expression) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "AssignField");
        m.put("fieldName", expression.fieldName());
        m.put("expression", expression.expression());
        return m;
    }
}

