/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.build_control.BuildControl;
import cool.scx.data.query.And;
import cool.scx.data.query.Condition;
import cool.scx.data.query.ConditionType;
import cool.scx.data.query.Junction;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;

public final class QueryBuilder {
    public static Query query() {
        return new QueryImpl();
    }

    public static Query query(Query oldQuery) {
        return new QueryImpl(oldQuery);
    }

    public static Query where(Where where) {
        return new QueryImpl().where(where);
    }

    public static Query orderBys(OrderBy ... orderBys) {
        return new QueryImpl().orderBys(orderBys);
    }

    public static Query offset(long offset) {
        return new QueryImpl().offset(offset);
    }

    public static Query limit(long limit) {
        return new QueryImpl().limit(limit);
    }

    public static Junction and(Where ... clauses) {
        return new And().add(clauses);
    }

    public static Junction or(Where ... clauses) {
        return new Or().add(clauses);
    }

    public static Not not(Where clause) {
        return new Not(clause);
    }

    public static OrderBy asc(String name, BuildControl ... options) {
        return new OrderBy(name, OrderByType.ASC, options);
    }

    public static OrderBy desc(String name, BuildControl ... options) {
        return new OrderBy(name, OrderByType.DESC, options);
    }

    public static Condition eq(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.EQ, value, null, options);
    }

    public static Condition ne(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.NE, value, null, options);
    }

    public static Condition lt(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.LT, value, null, options);
    }

    public static Condition lte(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.LTE, value, null, options);
    }

    public static Condition gt(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.GT, value, null, options);
    }

    public static Condition gte(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.GTE, value, null, options);
    }

    public static Condition like(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.LIKE, value, null, options);
    }

    public static Condition notLike(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.NOT_LIKE, value, null, options);
    }

    public static Condition likeRegex(String fieldName, String value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.LIKE_REGEX, (Object)value, null, options);
    }

    public static Condition notLikeRegex(String fieldName, String value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.NOT_LIKE_REGEX, (Object)value, null, options);
    }

    public static Condition in(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.IN, value, null, options);
    }

    public static Condition notIn(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.NOT_IN, value, null, options);
    }

    public static Condition between(String fieldName, Object value1, Object value2, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.BETWEEN, value1, value2, options);
    }

    public static Condition notBetween(String fieldName, Object value1, Object value2, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.NOT_BETWEEN, value1, value2, options);
    }

    public static Condition jsonContains(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.JSON_CONTAINS, value, null, options);
    }

    public static Condition jsonOverlaps(String fieldName, Object value, BuildControl ... options) {
        return new Condition(fieldName, ConditionType.JSON_OVERLAPS, value, null, options);
    }

    public static WhereClause whereClause(String whereClause, Object ... params) {
        return new WhereClause(whereClause, params);
    }
}

