/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.build_control.BuildControl;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.Query;
import cool.scx.data.query.Where;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class QueryImpl
implements Query {
    private Where where = null;
    private List<OrderBy> orderBys = new ArrayList<OrderBy>();
    private Long offset = null;
    private Long limit = null;

    public QueryImpl() {
    }

    public QueryImpl(Query oldQuery) {
        this();
        this.where(oldQuery.getWhere());
        this.orderBys(oldQuery.getOrderBys());
        if (oldQuery.getOffset() != null) {
            this.offset(oldQuery.getOffset());
        }
        if (oldQuery.getLimit() != null) {
            this.limit(oldQuery.getLimit());
        }
    }

    @Override
    public QueryImpl where(Where where) {
        this.where = where;
        return this;
    }

    @Override
    public QueryImpl orderBys(OrderBy ... orderBys) {
        this.orderBys = new ArrayList<OrderBy>(List.of(orderBys));
        return this;
    }

    @Override
    public QueryImpl offset(long offset) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Limit \u53c2\u6570\u9519\u8bef : offset (\u504f\u79fb\u91cf) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        this.offset = offset;
        return this;
    }

    @Override
    public QueryImpl limit(long limit) {
        if (limit < 0L) {
            throw new IllegalArgumentException("Limit \u53c2\u6570\u9519\u8bef : limit (\u884c\u957f\u5ea6) \u4e0d\u80fd\u5c0f\u4e8e 0 !!!");
        }
        this.limit = limit;
        return this;
    }

    @Override
    public Where getWhere() {
        return this.where;
    }

    @Override
    public OrderBy[] getOrderBys() {
        return (OrderBy[])this.orderBys.toArray(OrderBy[]::new);
    }

    @Override
    public Long getOffset() {
        return this.offset;
    }

    @Override
    public Long getLimit() {
        return this.limit;
    }

    @Override
    public QueryImpl clearWhere() {
        this.where = null;
        return this;
    }

    @Override
    public QueryImpl clearOrderBys() {
        this.orderBys.clear();
        return this;
    }

    @Override
    public QueryImpl clearOffset() {
        this.offset = null;
        return this;
    }

    @Override
    public QueryImpl clearLimit() {
        this.limit = null;
        return this;
    }

    @Override
    public QueryImpl orderBy(OrderBy ... orderBys) {
        Collections.addAll(this.orderBys, orderBys);
        return this;
    }

    @Override
    public QueryImpl asc(String selector, BuildControl ... options) {
        this.orderBy(new OrderBy(selector, OrderByType.ASC, options));
        return this;
    }

    @Override
    public QueryImpl desc(String selector, BuildControl ... options) {
        this.orderBy(new OrderBy(selector, OrderByType.DESC, options));
        return this;
    }
}

