/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.query.And;
import cool.scx.data.query.Condition;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.Query;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class QuerySerializer {
    public static final QuerySerializer QUERY_SERIALIZER = new QuerySerializer();

    public String toJson(Query query) throws JsonProcessingException {
        Object v = this.serialize(query);
        return ObjectUtils.jsonMapper().writeValueAsString(v);
    }

    public Object serialize(Query query) {
        return this.serializeQuery(query);
    }

    private Map<String, Object> serializeQuery(Query query) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Query");
        m.put("where", this.serializeWhere(query.getWhere()));
        m.put("orderBys", this.serializeOrderBys(query.getOrderBys()));
        m.put("offset", query.getOffset());
        m.put("limit", query.getLimit());
        return m;
    }

    public Object serializeWhere(Where obj) {
        Where where = obj;
        Objects.requireNonNull(where);
        Where where2 = where;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{WhereClause.class, And.class, Or.class, Not.class, Condition.class, Query.class}, (Where)where2, n)) {
            case 0 -> {
                WhereClause w = (WhereClause)where2;
                yield this.serializeWhereClause(w);
            }
            case 1 -> {
                And a = (And)where2;
                yield this.serializeAnd(a);
            }
            case 2 -> {
                Or o = (Or)where2;
                yield this.serializeOr(o);
            }
            case 3 -> {
                Not n = (Not)where2;
                yield this.serializeNot(n);
            }
            case 4 -> {
                Condition conditionBody = (Condition)where2;
                yield this.serializeCondition(conditionBody);
            }
            case 5 -> {
                Query q = (Query)((Object)where2);
                yield this.serializeWhere(q.getWhere());
            }
            default -> throw new IllegalArgumentException("Unknown Where type: " + String.valueOf(obj));
        };
    }

    private LinkedHashMap<String, Object> serializeWhereClause(WhereClause w) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "WhereClause");
        m.put("whereClause", w.whereClause());
        m.put("params", w.params());
        return m;
    }

    private Map<String, Object> serializeAnd(And a) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "And");
        m.put("clauses", this.serializeWhereAll(a.clauses()));
        return m;
    }

    private Map<String, Object> serializeOr(Or o) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Or");
        m.put("clauses", this.serializeWhereAll(o.clauses()));
        return m;
    }

    private Map<String, Object> serializeNot(Not n) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Not");
        m.put("clause", this.serializeWhere(n.clause()));
        return m;
    }

    private Map<String, Object> serializeCondition(Condition w) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "Condition");
        m.put("selector", w.selector());
        m.put("conditionType", (Object)w.conditionType());
        m.put("value1", w.value1());
        m.put("value2", w.value2());
        m.put("info", w.info());
        return m;
    }

    private Object[] serializeWhereAll(Where[] objs) {
        Object[] arr = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            arr[i] = this.serializeWhere(objs[i]);
        }
        return arr;
    }

    public Object serializeOrderBys(OrderBy ... objs) {
        Object[] arr = new Object[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            arr[i] = this.serializeOrderBy(objs[i]);
        }
        return arr;
    }

    private Object serializeOrderBy(OrderBy orderByBody) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("@type", "OrderBy");
        m.put("selector", orderByBody.selector());
        m.put("orderByType", (Object)orderByBody.orderByType());
        m.put("info", orderByBody.info());
        return m;
    }
}

