/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.field_policy.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyImpl;
import cool.scx.data.field_policy.FilterMode;
import cool.scx.data.field_policy.VirtualField;
import java.util.ArrayList;
import java.util.Map;

public class FieldPolicyDeserializer {
    public static final FieldPolicyDeserializer FIELD_POLICY_DESERIALIZER = new FieldPolicyDeserializer();

    public FieldPolicy fromJson(String json) throws JsonProcessingException {
        JsonNode v = ObjectUtils.jsonMapper().readTree(json);
        return this.deserialize(v);
    }

    public FieldPolicy deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("FieldPolicy")) {
            return this.deserializeFieldPolicy(v);
        }
        throw new IllegalArgumentException("Invalid field policy: " + String.valueOf(v));
    }

    private FieldPolicy deserializeFieldPolicy(JsonNode objectNode) {
        FilterMode filterMode = FilterMode.EXCLUDED;
        if (objectNode == null) {
            return new FieldPolicyImpl(filterMode);
        }
        JsonNode filterModeNode = objectNode.get("filterMode");
        JsonNode fieldNamesNode = objectNode.get("fieldNames");
        JsonNode virtualFieldsNode = objectNode.get("virtualFields");
        JsonNode ignoreNullNode = objectNode.get("ignoreNull");
        JsonNode ignoreNullsNode = objectNode.get("ignoreNulls");
        JsonNode expressionsNode = objectNode.get("expressions");
        if (filterModeNode != null && !filterModeNode.isNull()) {
            filterMode = (FilterMode)((Object)ObjectUtils.convertValue((Object)filterModeNode, FilterMode.class));
        }
        FieldPolicyImpl fieldPolicy = new FieldPolicyImpl(filterMode);
        if (fieldNamesNode != null && !fieldNamesNode.isNull()) {
            String[] fieldNames = (String[])ObjectUtils.convertValue((Object)fieldNamesNode, String[].class);
            fieldPolicy.addFieldNames(fieldNames);
        }
        if (virtualFieldsNode != null && !virtualFieldsNode.isNull()) {
            ArrayList<VirtualField> a = new ArrayList<VirtualField>();
            for (JsonNode jsonNode : virtualFieldsNode) {
                a.add(this.deserializeVirtualField(jsonNode));
            }
            fieldPolicy.virtualFields((VirtualField[])a.toArray(VirtualField[]::new));
        }
        if (ignoreNullNode != null && !ignoreNullNode.isNull()) {
            boolean ignoreNull = ignoreNullNode.asBoolean();
            fieldPolicy.ignoreNull(ignoreNull);
        }
        if (ignoreNullsNode != null && !ignoreNullsNode.isNull()) {
            Map ignoreNulls = (Map)ObjectUtils.convertValue((Object)ignoreNullsNode, (TypeReference)new TypeReference<Map<String, Boolean>>(this){});
            for (Map.Entry entry : ignoreNulls.entrySet()) {
                fieldPolicy.ignoreNull((String)entry.getKey(), (Boolean)entry.getValue());
            }
        }
        if (expressionsNode != null && !expressionsNode.isNull()) {
            ArrayList<AssignField> a = new ArrayList<AssignField>();
            for (JsonNode jsonNode : expressionsNode) {
                a.add(this.deserializeAssignField(jsonNode));
            }
            fieldPolicy.assignFields((AssignField[])a.toArray(AssignField[]::new));
        }
        return fieldPolicy;
    }

    public VirtualField deserializeVirtualField(JsonNode v) {
        JsonNode expressionNode = v.get("expression");
        JsonNode virtualFieldNameNode = v.get("virtualFieldName");
        return new VirtualField(expressionNode.asText(), virtualFieldNameNode.asText());
    }

    public AssignField deserializeAssignField(JsonNode v) {
        JsonNode fieldNameNode = v.get("fieldName");
        JsonNode expressionNode = v.get("expression");
        return new AssignField(fieldNameNode.asText(), expressionNode.asText());
    }
}

