/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.build_control.BuildControl;
import cool.scx.data.query.And;
import cool.scx.data.query.Condition;
import cool.scx.data.query.ConditionType;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.QueryLike;
import cool.scx.data.query.Where;
import java.util.ArrayList;
import java.util.List;

public abstract sealed class Junction
extends QueryLike<Junction>
implements Where
permits And, Or {
    private final List<Where> clauses = new ArrayList<Where>();

    protected Junction() {
    }

    public Where[] clauses() {
        return (Where[])this.clauses.toArray(Where[]::new);
    }

    public Junction add(Where ... logicCauses) {
        for (Where logicCause : logicCauses) {
            Condition w;
            if (logicCause == null) continue;
            if (logicCause instanceof Condition && (w = (Condition)logicCause).info().replace()) {
                this.clauses.removeIf(c -> {
                    Condition w1;
                    return c instanceof Condition && (w1 = (Condition)c).selector().equals(w.selector());
                });
            }
            this.clauses.add(logicCause);
        }
        return this;
    }

    public Junction clear() {
        this.clauses.clear();
        return this;
    }

    public final Junction eq(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.EQ, value, null, options));
    }

    public final Junction ne(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.NE, value, null, options));
    }

    public final Junction lt(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.LT, value, null, options));
    }

    public final Junction lte(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.LTE, value, null, options));
    }

    public final Junction gt(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.GT, value, null, options));
    }

    public final Junction gte(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.GTE, value, null, options));
    }

    public final Junction like(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.LIKE, value, null, options));
    }

    public final Junction notLike(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.NOT_LIKE, value, null, options));
    }

    public final Junction likeRegex(String selector, String value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.LIKE_REGEX, (Object)value, null, options));
    }

    public final Junction notLikeRegex(String selector, String value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.NOT_LIKE_REGEX, (Object)value, null, options));
    }

    public final Junction in(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.IN, value, null, options));
    }

    public final Junction notIn(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.NOT_IN, value, null, options));
    }

    public final Junction between(String selector, Object value1, Object value2, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.BETWEEN, value1, value2, options));
    }

    public final Junction notBetween(String selector, Object value1, Object value2, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.NOT_BETWEEN, value1, value2, options));
    }

    public final Junction jsonContains(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.JSON_CONTAINS, value, null, options));
    }

    public final Junction jsonOverlaps(String selector, Object value, BuildControl ... options) {
        return this.add(new Condition(selector, ConditionType.JSON_OVERLAPS, value, null, options));
    }

    public final Junction and(Where ... clauses) {
        return this.add(new And().add(clauses));
    }

    public final Junction or(Where ... clauses) {
        return this.add(new Or().add(clauses));
    }

    public final Junction not(Where clause) {
        return this.add(new Not(clause));
    }

    @Override
    protected QueryImpl toQuery() {
        return new QueryImpl().where(this);
    }
}

