/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query.serializer;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.query.And;
import cool.scx.data.query.Condition;
import cool.scx.data.query.ConditionType;
import cool.scx.data.query.Junction;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.SkipIfInfo;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import java.util.ArrayList;

public class QueryDeserializer {
    public static final QueryDeserializer QUERY_DESERIALIZER = new QueryDeserializer();

    public Query fromJson(String json) throws JsonProcessingException {
        JsonNode v = ObjectUtils.jsonMapper().readTree(json);
        return this.deserialize(v);
    }

    public Query deserialize(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("Query")) {
            return this.deserializeQuery(v);
        }
        throw new IllegalArgumentException("Unknown query type: " + String.valueOf(v));
    }

    public Query deserializeQuery(JsonNode objectNode) {
        QueryImpl query = new QueryImpl();
        if (objectNode == null) {
            return query;
        }
        JsonNode whereNode = objectNode.get("where");
        JsonNode orderBysNode = objectNode.get("orderBys");
        JsonNode offsetNode = objectNode.get("offset");
        JsonNode limitNode = objectNode.get("limit");
        if (whereNode != null && !whereNode.isNull()) {
            Where where = this.deserializeWhere(whereNode);
            query.where(where);
        }
        if (orderBysNode != null && !orderBysNode.isNull()) {
            OrderBy[] orderBys = this.deserializeOrderByAll(orderBysNode);
            query.orderBys(orderBys);
        }
        if (offsetNode != null && !offsetNode.isNull()) {
            query.offset(offsetNode.asLong());
        }
        if (limitNode != null && !limitNode.isNull()) {
            query.limit(limitNode.asLong());
        }
        return query;
    }

    public OrderBy deserializeOrderBy(JsonNode v) {
        String type;
        if (v.isObject() && (type = v.get("@type").asText()).equals("OrderBy")) {
            return this.deserializeOrderBy0(v);
        }
        throw new IllegalArgumentException("Unknown orderBy type: " + String.valueOf(v));
    }

    private OrderBy deserializeOrderBy0(JsonNode v) {
        String selector = v.get("selector").asText();
        OrderByType orderByType = (OrderByType)((Object)ObjectUtils.convertValue((Object)v.get("orderByType"), OrderByType.class));
        boolean useExpression = v.path("useExpression").asBoolean();
        return new OrderBy(selector, orderByType, useExpression);
    }

    private OrderBy[] deserializeOrderByAll(JsonNode v) {
        ArrayList<OrderBy> s = new ArrayList<OrderBy>();
        for (JsonNode jsonNode : v) {
            s.add(this.deserializeOrderBy(jsonNode));
        }
        return (OrderBy[])s.toArray(OrderBy[]::new);
    }

    public Where deserializeWhere(JsonNode v) {
        if (v == null || v.isNull()) {
            return null;
        }
        if (v.isObject()) {
            String type;
            switch (type = v.get("@type").asText()) {
                case "And": {
                    return this.deserializeAnd(v);
                }
                case "Or": {
                    return this.deserializeOr(v);
                }
                case "Not": {
                    return this.deserializeNot(v);
                }
                case "WhereClause": {
                    return this.deserializeWhereClause(v);
                }
                case "Condition": {
                    return this.deserializeCondition(v);
                }
            }
        }
        throw new IllegalArgumentException("Unknown query type: " + String.valueOf(v));
    }

    private Junction deserializeAnd(JsonNode v) {
        Where[] clauses = this.deserializeWhereAll(v.get("clauses"));
        return new And().add(clauses);
    }

    private Junction deserializeOr(JsonNode v) {
        Where[] clauses = this.deserializeWhereAll(v.get("clauses"));
        return new Or().add(clauses);
    }

    private Not deserializeNot(JsonNode v) {
        Where clause = this.deserializeWhere(v.get("clause"));
        return new Not(clause);
    }

    private WhereClause deserializeWhereClause(JsonNode v) {
        String whereClause = v.get("whereClause").asText();
        Object[] params = (Object[])ObjectUtils.convertValue((Object)v.get("params"), Object[].class);
        return new WhereClause(whereClause, params);
    }

    private Condition deserializeCondition(JsonNode v) {
        String selector = v.get("selector").asText();
        ConditionType conditionType = (ConditionType)((Object)ObjectUtils.convertValue((Object)v.get("conditionType"), ConditionType.class));
        Object value1 = ObjectUtils.convertValue((Object)v.get("value1"), Object.class);
        Object value2 = ObjectUtils.convertValue((Object)v.get("value2"), Object.class);
        boolean useExpression = v.get("useExpression").asBoolean();
        boolean useExpressionValue = v.get("useExpressionValue").asBoolean();
        SkipIfInfo skipIfInfo = (SkipIfInfo)ObjectUtils.convertValue((Object)v.get("skipIfInfo"), SkipIfInfo.class);
        return new Condition(selector, conditionType, value1, value2, useExpression, useExpressionValue, skipIfInfo);
    }

    private Where[] deserializeWhereAll(JsonNode v) {
        ArrayList<Where> s = new ArrayList<Where>();
        for (JsonNode jsonNode : v) {
            s.add(this.deserializeWhere(jsonNode));
        }
        return (Where[])s.toArray(Where[]::new);
    }
}

