/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.And;
import cool.scx.data.query.BuildControl;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.QueryBuilder;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.QueryLike;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract sealed class Junction
extends QueryLike<Junction>
implements Where
permits And, Or {
    private final List<Where> clauses = new ArrayList<Where>();

    protected Junction() {
    }

    public Where[] clauses() {
        return (Where[])this.clauses.toArray(Where[]::new);
    }

    public Junction add(Where ... wheres) {
        Collections.addAll(this.clauses, wheres);
        return this;
    }

    public Junction clear() {
        this.clauses.clear();
        return this;
    }

    public final Junction eq(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.eq(selector, value, controls));
    }

    public final Junction ne(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.ne(selector, value, controls));
    }

    public final Junction lt(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.lt(selector, value, controls));
    }

    public final Junction lte(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.lte(selector, value, controls));
    }

    public final Junction gt(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.gt(selector, value, controls));
    }

    public final Junction gte(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.gte(selector, value, controls));
    }

    public final Junction like(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.like(selector, value, controls));
    }

    public final Junction notLike(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.notLike(selector, value, controls));
    }

    public final Junction likeRegex(String selector, String value, BuildControl ... controls) {
        return this.add(QueryBuilder.likeRegex(selector, value, controls));
    }

    public final Junction notLikeRegex(String selector, String value, BuildControl ... controls) {
        return this.add(QueryBuilder.notLikeRegex(selector, value, controls));
    }

    public final Junction in(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.in(selector, value, controls));
    }

    public final Junction notIn(String selector, Object value, BuildControl ... controls) {
        return this.add(QueryBuilder.notIn(selector, value, controls));
    }

    public final Junction between(String selector, Object value1, Object value2, BuildControl ... controls) {
        return this.add(QueryBuilder.between(selector, value1, value2, controls));
    }

    public final Junction notBetween(String selector, Object value1, Object value2, BuildControl ... controls) {
        return this.add(QueryBuilder.notBetween(selector, value1, value2, controls));
    }

    public final Junction and(Where ... clauses) {
        return this.add(new And().add(clauses));
    }

    public final Junction or(Where ... clauses) {
        return this.add(new Or().add(clauses));
    }

    public final Junction not(Where clause) {
        return this.add(new Not(clause));
    }

    public final Junction whereClause(String expression, Object ... params) {
        return this.add(new WhereClause(expression, params));
    }

    @Override
    public boolean isEmpty() {
        for (Where clause : this.clauses) {
            if (clause == null || clause.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    protected QueryImpl toQuery() {
        return new QueryImpl().where(this);
    }
}

