/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.aggregation.Agg;
import cool.scx.data.aggregation.Aggregation;
import cool.scx.data.aggregation.AggregationImpl;
import cool.scx.data.aggregation.ExpressionGroupBy;
import cool.scx.data.aggregation.FieldGroupBy;
import cool.scx.data.aggregation.GroupBy;
import cool.scx.data.serialization.DeserializationException;
import java.util.ArrayList;

public class AggregationDeserializer {
    public static Aggregation deserializeAggregationFromJson(String json) throws DeserializationException {
        try {
            JsonNode v = ObjectUtils.jsonMapper().readTree(json);
            return AggregationDeserializer.deserializeAggregation(v);
        }
        catch (JsonProcessingException e) {
            throw new DeserializationException(e);
        }
    }

    public static Aggregation deserializeAggregation(JsonNode v) throws DeserializationException {
        if (v == null || v.isNull()) {
            throw new DeserializationException("Aggregation object is null or empty");
        }
        if (!v.isObject()) {
            throw new DeserializationException("Aggregation node is not an object: " + String.valueOf(v));
        }
        JsonNode typeNode = v.get("@type");
        if (typeNode == null || !"Aggregation".equals(typeNode.asText())) {
            throw new DeserializationException("Unknown or missing @type for Aggregation: " + String.valueOf(v));
        }
        JsonNode groupBysNode = v.get("groupBys");
        if (groupBysNode == null || !groupBysNode.isArray()) {
            throw new DeserializationException("groupBys node is not an array: " + String.valueOf(v));
        }
        ArrayList<GroupBy> groupByList = new ArrayList<GroupBy>();
        for (JsonNode gbNode : groupBysNode) {
            groupByList.add(AggregationDeserializer.deserializeGroupBy(gbNode));
        }
        GroupBy[] groupBys = (GroupBy[])groupByList.toArray(GroupBy[]::new);
        JsonNode aggsNode = v.get("aggs");
        if (aggsNode == null || !aggsNode.isArray()) {
            throw new DeserializationException("aggs node is not an array: " + String.valueOf(v));
        }
        ArrayList<Agg> aggList = new ArrayList<Agg>();
        for (JsonNode aggNode : aggsNode) {
            aggList.add(AggregationDeserializer.deserializeAgg(aggNode));
        }
        Agg[] aggs = (Agg[])aggList.toArray(Agg[]::new);
        return new AggregationImpl().aggs(aggs).groupBys(groupBys);
    }

    private static GroupBy deserializeGroupBy(JsonNode node) throws DeserializationException {
        if (node == null || node.isNull()) {
            throw new DeserializationException("Invalid JSON for GroupBy");
        }
        JsonNode typeNode = node.get("@type");
        if (typeNode == null) {
            throw new DeserializationException("Unknown or missing @type for GroupBy: " + String.valueOf(node));
        }
        String type = typeNode.asText();
        if (type.equals("FieldGroupBy")) {
            return AggregationDeserializer.deserializeFieldGroupBy(node);
        }
        if (type.equals("ExpressionGroupBy")) {
            return AggregationDeserializer.deserializeExpressionGroupBy(node);
        }
        throw new DeserializationException("Unknown GroupBy type: " + type);
    }

    public static FieldGroupBy deserializeFieldGroupBy(JsonNode node) throws DeserializationException {
        JsonNode fieldNameNode = node.get("fieldName");
        if (fieldNameNode == null || fieldNameNode.isNull()) {
            throw new DeserializationException("Invalid JSON for FieldGroupBy");
        }
        String fieldName = fieldNameNode.asText();
        return new FieldGroupBy(fieldName);
    }

    public static ExpressionGroupBy deserializeExpressionGroupBy(JsonNode node) throws DeserializationException {
        JsonNode aliasNode = node.get("alias");
        if (aliasNode == null || aliasNode.isNull()) {
            throw new DeserializationException("Invalid JSON for ExpressionGroupBy");
        }
        JsonNode expressionNode = node.get("expression");
        if (expressionNode == null || expressionNode.isNull()) {
            throw new DeserializationException("Invalid JSON for ExpressionGroupBy");
        }
        String alias = aliasNode.asText();
        String expression = expressionNode.asText();
        return new ExpressionGroupBy(alias, expression);
    }

    private static Agg deserializeAgg(JsonNode node) throws DeserializationException {
        if (node == null || node.isNull()) {
            throw new DeserializationException("Invalid JSON for Agg");
        }
        JsonNode typeNode = node.get("@type");
        if (typeNode == null || !"Agg".equals(typeNode.asText())) {
            throw new DeserializationException("Unknown or missing @type for Agg: " + String.valueOf(node));
        }
        JsonNode aliasNode = node.get("alias");
        if (aliasNode == null || !aliasNode.isTextual()) {
            throw new DeserializationException("Invalid JSON for Agg");
        }
        JsonNode expressionNode = node.get("expression");
        if (expressionNode == null || !expressionNode.isTextual()) {
            throw new DeserializationException("Invalid JSON for Agg");
        }
        String alias = aliasNode.asText();
        String expression = expressionNode.asText();
        return new Agg(alias, expression);
    }
}

