/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.serialization;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import cool.scx.common.util.ObjectUtils;
import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyImpl;
import cool.scx.data.field_policy.FilterMode;
import cool.scx.data.field_policy.VirtualField;
import cool.scx.data.serialization.DeserializationException;
import java.util.ArrayList;
import java.util.Map;

public class FieldPolicyDeserializer {
    public static FieldPolicy deserializeFieldPolicyFromJson(String json) throws DeserializationException {
        try {
            JsonNode v = ObjectUtils.jsonMapper().readTree(json);
            return FieldPolicyDeserializer.deserializeFieldPolicy(v);
        }
        catch (JsonProcessingException e) {
            throw new DeserializationException(e);
        }
    }

    public static FieldPolicy deserializeFieldPolicy(JsonNode v) throws DeserializationException {
        if (v == null || v.isNull()) {
            throw new DeserializationException("FieldPolicy node is null");
        }
        if (!v.isObject()) {
            throw new DeserializationException("FieldPolicy node is not an object: " + String.valueOf(v));
        }
        JsonNode typeNode = v.get("@type");
        if (typeNode == null || !"FieldPolicy".equals(typeNode.asText())) {
            throw new DeserializationException("Unknown or missing @type for FieldPolicy: " + String.valueOf(v));
        }
        JsonNode filterModeNode = v.get("filterMode");
        if (filterModeNode == null || filterModeNode.isNull()) {
            throw new DeserializationException("FilterMode node is null");
        }
        FilterMode filterMode = (FilterMode)((Object)ObjectUtils.convertValue((Object)filterModeNode, FilterMode.class));
        FieldPolicyImpl policy = new FieldPolicyImpl(filterMode);
        JsonNode fieldNamesNode = v.get("fieldNames");
        if (fieldNamesNode == null || !fieldNamesNode.isArray()) {
            throw new DeserializationException("FieldNames node is null or not an array: " + String.valueOf(v));
        }
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (JsonNode fn : fieldNamesNode) {
            fieldNames.add(fn.asText());
        }
        policy.addFieldNames((String[])fieldNames.toArray(String[]::new));
        JsonNode virtualFieldsNode = v.get("virtualFields");
        if (virtualFieldsNode == null || !virtualFieldsNode.isArray()) {
            throw new DeserializationException("VirtualFields node is null or not an array: " + String.valueOf(v));
        }
        ArrayList<VirtualField> virtualFields = new ArrayList<VirtualField>();
        for (JsonNode jsonNode : virtualFieldsNode) {
            virtualFields.add(FieldPolicyDeserializer.deserializeVirtualField(jsonNode));
        }
        policy.virtualFields((VirtualField[])virtualFields.toArray(VirtualField[]::new));
        JsonNode assignFieldsNode = v.get("assignFields");
        if (assignFieldsNode == null || !assignFieldsNode.isArray()) {
            throw new DeserializationException("AssignFields node is null or not an array: " + String.valueOf(v));
        }
        ArrayList<AssignField> assignFields = new ArrayList<AssignField>();
        for (JsonNode jsonNode : assignFieldsNode) {
            assignFields.add(FieldPolicyDeserializer.deserializeAssignField(jsonNode));
        }
        policy.assignFields((AssignField[])assignFields.toArray(AssignField[]::new));
        JsonNode ignoreNullNode = v.get("ignoreNull");
        if (ignoreNullNode == null || ignoreNullNode.isNull()) {
            throw new DeserializationException("IgnoreNull node is null: " + String.valueOf(v));
        }
        boolean ignoreNull = ignoreNullNode.asBoolean(true);
        policy.ignoreNull(ignoreNull);
        JsonNode ignoreNullsNode = v.get("ignoreNulls");
        if (ignoreNullsNode == null || !ignoreNullsNode.isObject()) {
            throw new DeserializationException("IgnoreNulls node is null or not an map: " + String.valueOf(v));
        }
        Map ignoreNulls = (Map)ObjectUtils.convertValue((Object)ignoreNullsNode, (TypeReference)new TypeReference<Map<String, Boolean>>(){});
        for (Map.Entry e : ignoreNulls.entrySet()) {
            policy.ignoreNull((String)e.getKey(), (Boolean)e.getValue());
        }
        return policy;
    }

    private static VirtualField deserializeVirtualField(JsonNode node) throws DeserializationException {
        if (node == null || node.isNull()) {
            throw new DeserializationException("VirtualField node is null");
        }
        JsonNode typeNode = node.get("@type");
        if (typeNode == null || !"VirtualField".equals(typeNode.asText())) {
            throw new DeserializationException("Unknown or missing @type for VirtualField: " + String.valueOf(node));
        }
        JsonNode virtualFieldNameNode = node.get("virtualFieldName");
        JsonNode expressionNode = node.get("expression");
        if (virtualFieldNameNode == null || !virtualFieldNameNode.isTextual()) {
            throw new DeserializationException("VirtualFieldName node is null or not a string: " + String.valueOf(node));
        }
        if (expressionNode == null || !expressionNode.isTextual()) {
            throw new DeserializationException("Expression node is null or not a string: " + String.valueOf(node));
        }
        String virtualFieldName = virtualFieldNameNode.asText();
        String expression = expressionNode.asText();
        return new VirtualField(virtualFieldName, expression);
    }

    private static AssignField deserializeAssignField(JsonNode node) throws DeserializationException {
        if (node == null || node.isNull()) {
            throw new DeserializationException("AssignField node is null");
        }
        JsonNode typeNode = node.get("@type");
        if (typeNode == null || !"AssignField".equals(typeNode.asText())) {
            throw new DeserializationException("Unknown or missing @type for AssignField: " + String.valueOf(node));
        }
        JsonNode fieldNameNode = node.get("fieldName");
        JsonNode expressionNode = node.get("expression");
        if (fieldNameNode == null || !fieldNameNode.isTextual()) {
            throw new DeserializationException("AssignFieldName node is null or not a string: " + String.valueOf(node));
        }
        if (expressionNode == null || !expressionNode.isTextual()) {
            throw new DeserializationException("Expression node is null or not a string: " + String.valueOf(node));
        }
        String fieldName = fieldNameNode.asText();
        String expression = expressionNode.asText();
        return new AssignField(fieldName, expression);
    }
}

