/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data;

import cool.scx.data.Finder;
import cool.scx.data.exception.DataAccessException;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FieldPolicyBuilder;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryBuilder;
import java.util.Collection;
import java.util.List;

public interface Repository<Entity, ID> {
    public ID add(Entity var1, FieldPolicy var2) throws DataAccessException;

    public List<ID> add(Collection<Entity> var1, FieldPolicy var2) throws DataAccessException;

    public Finder<Entity> finder(Query var1, FieldPolicy var2);

    public long update(Entity var1, FieldPolicy var2, Query var3) throws DataAccessException;

    public long delete(Query var1) throws DataAccessException;

    public void clear() throws DataAccessException;

    default public ID add(Entity entity) throws DataAccessException {
        return this.add(entity, FieldPolicyBuilder.includeAll());
    }

    default public ID add(FieldPolicy fieldPolicy) throws DataAccessException {
        return this.add((Entity)null, fieldPolicy);
    }

    default public List<ID> add(Collection<Entity> entityList) throws DataAccessException {
        return this.add(entityList, FieldPolicyBuilder.includeAll());
    }

    default public Finder<Entity> finder(Query query) {
        return this.finder(query, FieldPolicyBuilder.includeAll());
    }

    default public Finder<Entity> finder(FieldPolicy fieldPolicy) {
        return this.finder(QueryBuilder.query(), fieldPolicy);
    }

    default public Finder<Entity> finder() {
        return this.finder(QueryBuilder.query(), FieldPolicyBuilder.includeAll());
    }

    default public List<Entity> find(Query query, FieldPolicy fieldPolicy) throws DataAccessException {
        return this.finder(query, fieldPolicy).list();
    }

    default public List<Entity> find(Query query) throws DataAccessException {
        return this.finder(query).list();
    }

    default public List<Entity> find(FieldPolicy fieldPolicy) throws DataAccessException {
        return this.finder(fieldPolicy).list();
    }

    default public List<Entity> find() throws DataAccessException {
        return this.finder().list();
    }

    default public Entity findFirst(Query query, FieldPolicy fieldPolicy) throws DataAccessException {
        return this.finder(query, fieldPolicy).first();
    }

    default public Entity findFirst(Query query) throws DataAccessException {
        return this.finder(query).first();
    }

    default public long update(Entity entity, Query query) throws DataAccessException {
        return this.update(entity, FieldPolicyBuilder.includeAll(), query);
    }

    default public long update(FieldPolicy fieldPolicy, Query query) throws DataAccessException {
        return this.update(null, fieldPolicy, query);
    }

    default public long count(Query query) throws DataAccessException {
        return this.finder(query).count();
    }

    default public long count() throws DataAccessException {
        return this.finder().count();
    }
}

