/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.And;
import cool.scx.data.query.BuildControl;
import cool.scx.data.query.Condition;
import cool.scx.data.query.ConditionType;
import cool.scx.data.query.Junction;
import cool.scx.data.query.Not;
import cool.scx.data.query.Or;
import cool.scx.data.query.OrderBy;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.Query;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.SkipIfInfo;
import cool.scx.data.query.Where;
import cool.scx.data.query.WhereClause;

public final class QueryBuilder {
    public static Query query() {
        return new QueryImpl();
    }

    public static Query query(Query oldQuery) {
        return new QueryImpl(oldQuery);
    }

    public static Query where(Where where) {
        return new QueryImpl().where(where);
    }

    public static Query orderBys(OrderBy ... orderBys) {
        return new QueryImpl().orderBys(orderBys);
    }

    public static Query offset(long offset) {
        return new QueryImpl().offset(offset);
    }

    public static Query limit(long limit) {
        return new QueryImpl().limit(limit);
    }

    public static Junction and(Where ... clauses) {
        return new And().add(clauses);
    }

    public static Junction or(Where ... clauses) {
        return new Or().add(clauses);
    }

    public static Not not(Where clause) {
        return new Not(clause);
    }

    public static WhereClause whereClause(String expression, Object ... params) {
        return new WhereClause(expression, params);
    }

    public static Condition condition(String fieldName, ConditionType conditionType, Object value, BuildControl ... controls) {
        boolean useExpression = BuildControl.checkUseExpression(controls);
        boolean useExpressionValue = BuildControl.checkUseExpressionValue(controls);
        SkipIfInfo skipIfInfo = SkipIfInfo.ofSkipIfInfo(controls);
        return new Condition(fieldName, conditionType, value, null, useExpression, useExpressionValue, skipIfInfo);
    }

    public static Condition condition(String fieldName, ConditionType conditionType, Object value1, Object value2, BuildControl ... controls) {
        boolean useExpression = BuildControl.checkUseExpression(controls);
        boolean useExpressionValue = BuildControl.checkUseExpressionValue(controls);
        SkipIfInfo skipIfInfo = SkipIfInfo.ofSkipIfInfo(controls);
        return new Condition(fieldName, conditionType, value1, value2, useExpression, useExpressionValue, skipIfInfo);
    }

    public static OrderBy orderBy(String selector, OrderByType orderByType, BuildControl ... controls) {
        boolean useExpression = BuildControl.checkUseExpression(controls);
        return new OrderBy(selector, orderByType, useExpression);
    }

    public static OrderBy asc(String selector, BuildControl ... controls) {
        return QueryBuilder.orderBy(selector, OrderByType.ASC, controls);
    }

    public static OrderBy desc(String selector, BuildControl ... controls) {
        return QueryBuilder.orderBy(selector, OrderByType.DESC, controls);
    }

    public static Condition eq(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.EQ, value, controls);
    }

    public static Condition ne(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.NE, value, controls);
    }

    public static Condition lt(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.LT, value, controls);
    }

    public static Condition lte(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.LTE, value, controls);
    }

    public static Condition gt(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.GT, value, controls);
    }

    public static Condition gte(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.GTE, value, controls);
    }

    public static Condition like(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.LIKE, value, controls);
    }

    public static Condition notLike(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.NOT_LIKE, value, controls);
    }

    public static Condition likeRegex(String fieldName, String value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.LIKE_REGEX, (Object)value, controls);
    }

    public static Condition notLikeRegex(String fieldName, String value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.NOT_LIKE_REGEX, (Object)value, controls);
    }

    public static Condition in(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.IN, value, controls);
    }

    public static Condition notIn(String fieldName, Object value, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.NOT_IN, value, controls);
    }

    public static Condition between(String fieldName, Object value1, Object value2, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.BETWEEN, value1, value2, controls);
    }

    public static Condition notBetween(String fieldName, Object value1, Object value2, BuildControl ... controls) {
        return QueryBuilder.condition(fieldName, ConditionType.NOT_BETWEEN, value1, value2, controls);
    }
}

