/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.field_policy;

import cool.scx.data.field_policy.AssignField;
import cool.scx.data.field_policy.FieldPolicy;
import cool.scx.data.field_policy.FilterMode;
import cool.scx.data.field_policy.VirtualField;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FieldPolicyImpl
implements FieldPolicy {
    private final FilterMode filterMode;
    private final Set<String> fieldNames;
    private final Map<String, Boolean> ignoreNulls;
    private List<VirtualField> virtualFields;
    private List<AssignField> assignFields;
    private boolean ignoreNull;

    public FieldPolicyImpl(FilterMode filterMode) {
        this.filterMode = filterMode;
        this.fieldNames = new HashSet<String>();
        this.virtualFields = new ArrayList<VirtualField>();
        this.assignFields = new ArrayList<AssignField>();
        this.ignoreNulls = new LinkedHashMap<String, Boolean>();
        this.ignoreNull = true;
    }

    @Override
    public FieldPolicyImpl include(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.INCLUDED -> this.addFieldNames(fieldNames);
            case FilterMode.EXCLUDED -> this.removeFieldNames(fieldNames);
        };
    }

    @Override
    public FieldPolicyImpl exclude(String ... fieldNames) {
        return switch (this.filterMode) {
            default -> throw new MatchException(null, null);
            case FilterMode.EXCLUDED -> this.addFieldNames(fieldNames);
            case FilterMode.INCLUDED -> this.removeFieldNames(fieldNames);
        };
    }

    @Override
    public FilterMode getFilterMode() {
        return this.filterMode;
    }

    @Override
    public String[] getFieldNames() {
        return (String[])this.fieldNames.toArray(String[]::new);
    }

    @Override
    public FieldPolicyImpl clearFieldNames() {
        this.fieldNames.clear();
        return this;
    }

    @Override
    public FieldPolicyImpl virtualFields(VirtualField ... virtualFields) {
        this.virtualFields = new ArrayList<VirtualField>(List.of(virtualFields));
        return this;
    }

    @Override
    public VirtualField[] getVirtualFields() {
        return (VirtualField[])this.virtualFields.toArray(VirtualField[]::new);
    }

    @Override
    public FieldPolicyImpl clearVirtualFields() {
        this.virtualFields.clear();
        return this;
    }

    @Override
    public FieldPolicyImpl virtualField(String virtualFieldName, String expression) {
        this.virtualFields.add(new VirtualField(virtualFieldName, expression));
        return this;
    }

    @Override
    public FieldPolicyImpl ignoreNull(boolean ignoreNull) {
        this.ignoreNull = ignoreNull;
        return this;
    }

    @Override
    public FieldPolicyImpl ignoreNull(String fieldName, boolean ignoreNull) {
        this.ignoreNulls.put(fieldName, ignoreNull);
        return this;
    }

    @Override
    public FieldPolicyImpl assignFields(AssignField ... assignFields) {
        this.assignFields = new ArrayList<AssignField>(List.of(assignFields));
        return this;
    }

    @Override
    public boolean getIgnoreNull() {
        return this.ignoreNull;
    }

    @Override
    public Map<String, Boolean> getIgnoreNulls() {
        return this.ignoreNulls;
    }

    @Override
    public AssignField[] getAssignFields() {
        return (AssignField[])this.assignFields.toArray(AssignField[]::new);
    }

    @Override
    public FieldPolicyImpl clearIgnoreNulls() {
        this.ignoreNulls.clear();
        return this;
    }

    @Override
    public FieldPolicyImpl clearAssignFields() {
        this.assignFields.clear();
        return this;
    }

    @Override
    public FieldPolicyImpl removeIgnoreNull(String fieldName) {
        this.ignoreNulls.remove(fieldName);
        return this;
    }

    @Override
    public FieldPolicyImpl assignField(String fieldName, String expression) {
        this.assignFields.add(new AssignField(fieldName, expression));
        return this;
    }

    private FieldPolicyImpl addFieldNames(String ... fieldNames) {
        Collections.addAll(this.fieldNames, fieldNames);
        return this;
    }

    private FieldPolicyImpl removeFieldNames(String ... fieldNames) {
        for (String fieldName : fieldNames) {
            this.fieldNames.remove(fieldName);
        }
        return this;
    }
}

