/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.data.query;

import cool.scx.data.query.ConditionType;
import cool.scx.data.query.QueryImpl;
import cool.scx.data.query.QueryLike;
import cool.scx.data.query.SkipIfInfo;
import cool.scx.data.query.Where;

public final class Condition
extends QueryLike<Condition>
implements Where {
    private final String selector;
    private final ConditionType conditionType;
    private final Object value1;
    private final Object value2;
    private final boolean useExpression;
    private final boolean useExpressionValue;
    private final SkipIfInfo skipIfInfo;

    public Condition(String selector, ConditionType conditionType, Object value1, Object value2, boolean useExpression, boolean useExpressionValue, SkipIfInfo skipIfInfo) {
        if (selector == null) {
            throw new NullPointerException("selector cannot be null");
        }
        if (conditionType == null) {
            throw new NullPointerException("conditionType cannot be null");
        }
        this.selector = selector;
        this.conditionType = conditionType;
        this.value1 = value1;
        this.value2 = value2;
        this.useExpression = useExpression;
        this.useExpressionValue = useExpressionValue;
        this.skipIfInfo = skipIfInfo;
    }

    public String selector() {
        return this.selector;
    }

    public ConditionType conditionType() {
        return this.conditionType;
    }

    public Object value1() {
        return this.value1;
    }

    public Object value2() {
        return this.value2;
    }

    public boolean useExpression() {
        return this.useExpression;
    }

    public boolean useExpressionValue() {
        return this.useExpressionValue;
    }

    public SkipIfInfo skipIfInfo() {
        return this.skipIfInfo;
    }

    @Override
    public boolean isEmpty() {
        if (this.conditionType == ConditionType.BETWEEN || this.conditionType == ConditionType.NOT_BETWEEN) {
            return this.skipIfInfo.shouldSkip(this.value1, this.value2);
        }
        return this.skipIfInfo.shouldSkip(this.value1);
    }

    @Override
    protected QueryImpl toQuery() {
        return new QueryImpl().where(this);
    }
}

