/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth.type;

import cool.scx.ext.auth.type.DeviceType;
import cool.scx.ext.auth.type.Session;
import io.vertx.core.http.ServerWebSocket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public final class SessionStore {
    private final List<Session> list = new ArrayList<Session>();

    public void add(Session ... loggedInClients) {
        Collections.addAll(this.list, loggedInClients);
    }

    public void addAll(Collection<Session> loggedInClients) {
        this.list.addAll(loggedInClients);
    }

    public List<Session> getByUserID(Long userID) {
        return this.list.stream().filter(c -> Objects.equals(c.userID(), userID)).toList();
    }

    public List<Session> getByLoginDevice(DeviceType deviceType) {
        return this.list.stream().filter(c -> Objects.equals((Object)c.loginDevice(), (Object)deviceType)).toList();
    }

    public Session getByToken(String token) {
        return this.list.stream().filter(c -> Objects.equals(c.token(), token)).findAny().orElse(null);
    }

    public boolean removeByUserID(Long userID) {
        return this.list.removeIf(c -> Objects.equals(c.userID(), userID));
    }

    public boolean removeByLoginDevice(DeviceType deviceType) {
        return this.list.removeIf(c -> Objects.equals((Object)c.loginDevice(), (Object)deviceType));
    }

    public boolean removeByToken(String token) {
        return this.list.removeIf(c -> Objects.equals(c.token(), token));
    }

    public Session getByWebSocket(ServerWebSocket webSocket) {
        return this.list.stream().filter(c -> Objects.equals(c.webSocket, webSocket)).findAny().orElse(null);
    }

    public boolean removeByWebSocket(ServerWebSocket webSocket) {
        return this.list.removeIf(c -> Objects.equals(c.webSocket, webSocket));
    }

    public List<Session> loggedInClients() {
        return new ArrayList<Session>(this.list);
    }
}

