/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import cool.scx.common.util.StringUtils;
import cool.scx.ext.auth.AuthHelper;
import cool.scx.ext.auth.BaseAuthHandler;
import cool.scx.ext.auth.BaseUser;
import cool.scx.ext.auth.annotation.ApiPerms;
import cool.scx.mvc.ScxMvcInterceptor;
import cool.scx.mvc.ScxRouteHandler;
import cool.scx.mvc.exception.ForbiddenException;
import cool.scx.mvc.exception.UnauthorizedException;
import io.vertx.ext.web.RoutingContext;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public final class ApiPermsInterceptor
implements ScxMvcInterceptor {
    private final BaseAuthHandler<BaseUser> authHandler;
    private final Map<ScxRouteHandler, AuthPerms> SCX_AUTH_PERMS_CACHE = new HashMap<ScxRouteHandler, AuthPerms>();

    public ApiPermsInterceptor(BaseAuthHandler<BaseUser> authHandler) {
        this.authHandler = authHandler;
    }

    public void preHandle(RoutingContext context, ScxRouteHandler scxMappingHandler) {
        AuthPerms p = this.getScxAuthPerms(scxMappingHandler);
        if (p.needCheckPerms) {
            BaseUser currentUser = this.authHandler.getCurrentUser(context);
            if (currentUser == null) {
                throw new UnauthorizedException();
            }
            if (p.checkPerms && !currentUser.isAdmin.booleanValue() && !this.authHandler.getPerms(currentUser).apiPerms().contains(p.permStr)) {
                throw new ForbiddenException();
            }
        }
    }

    private AuthPerms getScxAuthPerms(ScxRouteHandler s) {
        AuthPerms p = this.SCX_AUTH_PERMS_CACHE.get(s);
        if (p == null) {
            p = new AuthPerms(s.clazz, s.method);
            this.SCX_AUTH_PERMS_CACHE.put(s, p);
        }
        return p;
    }

    private static final class AuthPerms {
        public final String permStr;
        public final boolean needCheckPerms;
        public final boolean checkPerms;

        public AuthPerms(Class<?> clazz, Method method) {
            String defaultPermStr = clazz.getSimpleName() + ":" + method.getName();
            ApiPerms apiPerms = AuthHelper.findApiPerms(method);
            if (apiPerms != null) {
                this.permStr = StringUtils.notBlank((String)apiPerms.value()) ? apiPerms.value() : defaultPermStr;
                this.checkPerms = apiPerms.checkPerms();
                this.needCheckPerms = true;
            } else {
                this.permStr = defaultPermStr;
                this.checkPerms = false;
                this.needCheckPerms = false;
            }
        }
    }
}

