/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import cool.scx.common.standard.HttpMethod;
import cool.scx.core.base.BaseModelService;
import cool.scx.data.FieldFilter;
import cool.scx.ext.auth.BaseAuthHandler;
import cool.scx.ext.auth.BaseUser;
import cool.scx.ext.auth.annotation.ApiPerms;
import cool.scx.ext.auth.exception.AuthException;
import cool.scx.ext.auth.type.Session;
import cool.scx.ext.auth.type.UserInfo;
import cool.scx.mvc.annotation.FromBody;
import cool.scx.mvc.annotation.ScxRoute;
import cool.scx.mvc.exception.UnauthorizedException;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.mvc.vo.Result;
import io.vertx.ext.web.RoutingContext;

public abstract class BaseAuthApi<T extends BaseUser> {
    protected final BaseAuthHandler<T> authHandler;
    protected final BaseModelService<T> userService;

    protected BaseAuthApi(BaseAuthHandler<T> authHandler, BaseModelService<T> userService) {
        this.authHandler = authHandler;
        this.userService = userService;
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo login(@FromBody String username, @FromBody String password, RoutingContext ctx) {
        try {
            Session session = this.authHandler.login(username, password, ctx);
            return Result.ok().put("token", (Object)session.token());
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo loginByThirdParty(@FromBody String uniqueID, @FromBody String accessToken, @FromBody String accountType, RoutingContext ctx) {
        try {
            Session loginResult = this.authHandler.loginByThirdParty(uniqueID, accessToken, accountType, ctx);
            return Result.ok().put("token", (Object)loginResult.token());
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo signup(@FromBody String username, @FromBody String password) {
        try {
            return Result.ok(this.authHandler.signup(username, password));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo signupByThirdParty(@FromBody String uniqueID, @FromBody String accessToken, @FromBody String accountType) {
        try {
            return Result.ok(this.authHandler.signupByThirdParty(uniqueID, accessToken, accountType));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo logout(RoutingContext routingContext) {
        this.authHandler.logout(routingContext);
        return Result.ok();
    }

    @ApiPerms(checkPerms=false)
    @ScxRoute(methods={HttpMethod.GET})
    public BaseVo info(RoutingContext routingContext) throws UnauthorizedException {
        T user = this.authHandler.getCurrentUser(routingContext);
        return Result.ok((Object)new UserInfo((BaseUser)((Object)user), this.authHandler.getPerms(user)));
    }

    @ApiPerms(checkPerms=false)
    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo changeUserAvatar(@FromBody String newAvatar) throws UnauthorizedException {
        T loginUser = this.authHandler.getCurrentUser();
        ((BaseUser)((Object)loginUser)).avatar = newAvatar;
        return Result.ok((Object)this.userService.update(loginUser, FieldFilter.ofIncluded((String[])new String[]{"avatar"})));
    }

    @ApiPerms(checkPerms=false)
    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo changeUsernameBySelf(@FromBody String newUsername, @FromBody String password) throws UnauthorizedException {
        try {
            return Result.ok(this.authHandler.changeUsernameBySelf(newUsername, password));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ApiPerms(checkPerms=false)
    @ScxRoute(methods={HttpMethod.POST})
    public BaseVo changePasswordBySelf(@FromBody String newPassword, @FromBody String oldPassword) throws UnauthorizedException {
        try {
            return Result.ok(this.authHandler.changePasswordBySelf(newPassword, oldPassword));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }

    @ApiPerms
    @ScxRoute(methods={HttpMethod.PUT})
    public BaseVo changePasswordByAdmin(@FromBody String newPassword, @FromBody Long userID) {
        try {
            return Result.ok(this.authHandler.changePasswordByAdmin(newPassword, userID));
        }
        catch (AuthException e) {
            return e.toBaseVo();
        }
    }
}

