/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.auth;

import cool.scx.common.reflect.MethodInfo;
import cool.scx.common.util.CryptoUtils;
import cool.scx.common.util.RandomUtils;
import cool.scx.ext.auth.PermsModel;
import cool.scx.ext.auth.annotation.ApiPerms;
import cool.scx.ext.auth.annotation.NoApiPerms;
import cool.scx.ext.auth.exception.AuthException;
import cool.scx.ext.auth.exception.UnknownDeviceException;
import cool.scx.ext.auth.type.DeviceType;
import cool.scx.ext.auth.type.Perms;
import io.vertx.core.http.Cookie;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.List;

public final class AuthHelper {
    public static String getToken(RoutingContext ctx) {
        DeviceType device = AuthHelper.getDeviceTypeByHeader(ctx);
        return switch (device) {
            case DeviceType.WEBSITE -> AuthHelper.getTokenFromCookie(ctx);
            case DeviceType.ADMIN, DeviceType.APPLE, DeviceType.ANDROID -> AuthHelper.getTokenFromHeader(ctx);
            default -> null;
        };
    }

    public static DeviceType getDeviceTypeByHeader(RoutingContext routingContext) {
        String device = routingContext.request().getHeader("S-Device");
        if (device == null) {
            return DeviceType.WEBSITE;
        }
        return DeviceType.of(device);
    }

    public static String getTokenFromCookie(RoutingContext routingContext) {
        Cookie cookie = routingContext.request().getCookie("S-Token");
        return cookie != null ? cookie.getValue() : null;
    }

    public static String getTokenFromHeader(RoutingContext routingContext) {
        return routingContext.request().getHeader("S-Token");
    }

    public static String tryGetAuthToken(RoutingContext ctx, DeviceType loginDevice) throws AuthException {
        return switch (loginDevice) {
            default -> throw new MatchException(null, null);
            case DeviceType.ADMIN, DeviceType.APPLE, DeviceType.ANDROID -> RandomUtils.randomUUID();
            case DeviceType.WEBSITE -> AuthHelper.getTokenFromCookie(ctx);
            case DeviceType.UNKNOWN -> throw new UnknownDeviceException();
        };
    }

    public static boolean checkPassword(String plainPassword, String encryptedPassword) {
        try {
            return CryptoUtils.checkPassword((String)plainPassword, (String)encryptedPassword);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static Perms mergePermsModels(List<PermsModel> permsModelList) {
        HashSet<String> pageElementPerms = new HashSet<String>();
        HashSet<String> pagePerms = new HashSet<String>();
        HashSet<String> perms = new HashSet<String>();
        HashSet<String> apiPerms = new HashSet<String>();
        for (PermsModel p : permsModelList) {
            if (p.pagePerms != null) {
                pagePerms.addAll(p.pagePerms);
            }
            if (p.pageElementPerms != null) {
                pageElementPerms.addAll(p.pageElementPerms);
            }
            if (p.perms != null) {
                perms.addAll(p.perms);
            }
            if (p.apiPerms == null) continue;
            apiPerms.addAll(p.apiPerms);
        }
        return new Perms(perms, pagePerms, pageElementPerms, apiPerms);
    }

    public static ApiPerms findApiPerms(MethodInfo m) {
        NoApiPerms noApiPerms = m.method().getAnnotation(NoApiPerms.class);
        if (noApiPerms != null) {
            return null;
        }
        return AuthHelper.findApiPerms0(m);
    }

    public static ApiPerms findApiPerms0(MethodInfo method) {
        Annotation[] annotations;
        for (Annotation a : annotations = method.allAnnotations()) {
            if (!(a instanceof ApiPerms)) continue;
            ApiPerms s = (ApiPerms)a;
            return s;
        }
        return null;
    }
}

