/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.common.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.RegionUtil;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public final class Excel {
    public final Workbook workbook;
    public final Sheet sheet;
    public final Map<Integer, Row> rowMap;

    private Excel(Workbook workbook, String sheetName, int rowSize) {
        this.workbook = workbook;
        this.sheet = workbook.createSheet(sheetName);
        this.rowMap = Excel.getRowMap(rowSize, this.sheet);
    }

    public static Excel get03Excel(String sheetName, int rowSize) {
        return new Excel((Workbook)new HSSFWorkbook(), sheetName, rowSize);
    }

    public static Excel get07Excel(String sheetName, int rowSize) {
        return new Excel((Workbook)new XSSFWorkbook(), sheetName, rowSize);
    }

    private static Map<Integer, Row> getRowMap(int size, Sheet sheet) {
        HashMap<Integer, Row> rowMap = new HashMap<Integer, Row>(size);
        for (int i = 0; i < size; ++i) {
            rowMap.put(i, sheet.createRow(i));
        }
        return rowMap;
    }

    public CellRangeAddress setBorder(int firstRow, int lastRow, int firstCol, int lastCol) {
        return this.setBorder(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public CellRangeAddress setBorder(CellRangeAddress cellAddresses) {
        RegionUtil.setBorderTop((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)this.sheet);
        RegionUtil.setBorderLeft((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)this.sheet);
        RegionUtil.setBorderRight((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)this.sheet);
        RegionUtil.setBorderBottom((BorderStyle)BorderStyle.THIN, (CellRangeAddress)cellAddresses, (Sheet)this.sheet);
        return cellAddresses;
    }

    public CellRangeAddress setBorder(int firstRow, int firstCol) {
        return this.setBorder(firstRow, firstRow, firstCol, firstCol);
    }

    public Sheet getSheet() {
        return this.workbook.createSheet();
    }

    public Sheet getSheet(String name) {
        return this.workbook.createSheet(name);
    }

    public CellRangeAddress mergedRegion(int firstRow, int firstCol, int down, int right) {
        int _firstRow = down >= 0 ? firstRow : firstRow + down;
        int _lastRow = down >= 0 ? firstRow + down : firstRow;
        int _firstCol = right >= 0 ? firstCol : firstCol + right;
        int _lastCol = right >= 0 ? firstCol + right : firstCol;
        return this.mergedRegion(new CellRangeAddress(_firstRow, _lastRow, _firstCol, _lastCol));
    }

    public CellRangeAddress mergedRegion(CellRangeAddress addresses) {
        this.sheet.addMergedRegion(addresses);
        return addresses;
    }

    public Cell setCellValue(int firstRow, int firstCol, String value, CellStyle xssfCellStyle) {
        Cell cell = this.rowMap.get(firstRow).createCell(firstCol);
        cell.setCellValue(value);
        cell.setCellStyle(xssfCellStyle);
        return cell;
    }

    public Cell setCellValue(int firstRow, int firstCol, String value) {
        Cell cell = this.rowMap.get(firstRow).createCell(firstCol);
        cell.setCellValue(value);
        return cell;
    }

    public CellStyle createCellStyle() {
        return this.workbook.createCellStyle();
    }

    public Font createFont() {
        return this.workbook.createFont();
    }

    public Row getRow(int rowIndex) {
        return this.rowMap.get(rowIndex);
    }

    public byte[] toBytes() {
        byte[] byArray;
        ByteArrayOutputStream o = new ByteArrayOutputStream();
        try {
            this.workbook.write((OutputStream)o);
            byArray = o.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    o.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        o.close();
        return byArray;
    }
}

