/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.config_manager;

import cool.scx.core.base.BaseModelService;
import cool.scx.data.Query;
import cool.scx.data.jdbc.ColumnFilter;
import cool.scx.data.query.WhereOption;
import cool.scx.ext.config_manager.BaseSystemConfig;
import cool.scx.ext.config_manager.BaseUserConfig;

public abstract class BaseConfigManager<S extends BaseSystemConfig, U extends BaseUserConfig> {
    public static final String DEFAULT_SYSTEM_CONFIG_NAME = "ScxSystemConfig";
    protected final BaseModelService<S> systemConfigService;
    protected final BaseModelService<U> userConfigService;

    public BaseConfigManager(BaseModelService<S> systemConfigService, BaseModelService<U> userConfigService) {
        this.systemConfigService = systemConfigService;
        this.userConfigService = userConfigService;
    }

    public U updateUserConfig(Long userID, U newScxConfig) {
        long size = this.userConfigService.update(newScxConfig, new Query().equal("userID", (Object)userID, new WhereOption[0]), ColumnFilter.ofExcluded().addExcluded(new String[]{"userID"}));
        if (size == 0L) {
            ((BaseUserConfig)((Object)newScxConfig)).userID = userID;
            return (U)((Object)((BaseUserConfig)this.userConfigService.add(newScxConfig)));
        }
        return this.getUserConfig(userID);
    }

    public U getUserConfig(Long userID) {
        BaseUserConfig config = (BaseUserConfig)this.userConfigService.get(new Query().equal("userID", (Object)userID, new WhereOption[0]));
        if (config == null) {
            U c = this.getDefaultUserConfig();
            ((BaseUserConfig)((Object)c)).userID = userID;
            config = (BaseUserConfig)this.userConfigService.add(c);
        }
        return (U)((Object)config);
    }

    public S getSystemConfig() {
        BaseSystemConfig config = (BaseSystemConfig)this.systemConfigService.get(new Query().equal("configName", (Object)DEFAULT_SYSTEM_CONFIG_NAME, new WhereOption[0]));
        if (config == null) {
            S c = this.getDefaultSystemConfig();
            ((BaseSystemConfig)((Object)c)).configName = DEFAULT_SYSTEM_CONFIG_NAME;
            config = (BaseSystemConfig)this.systemConfigService.add(c);
        }
        return (S)((Object)config);
    }

    public S updateSystemConfig(S newScxConfig) {
        long size = this.systemConfigService.update(newScxConfig, new Query().equal("configName", (Object)DEFAULT_SYSTEM_CONFIG_NAME, new WhereOption[0]), ColumnFilter.ofExcluded().addExcluded(new String[]{"configName"}));
        if (size == 0L) {
            ((BaseSystemConfig)((Object)newScxConfig)).configName = DEFAULT_SYSTEM_CONFIG_NAME;
            return (S)((Object)((BaseSystemConfig)this.systemConfigService.add(newScxConfig)));
        }
        return this.getSystemConfig();
    }

    public abstract U getDefaultUserConfig();

    public abstract S getDefaultSystemConfig();

    public final BaseModelService<S> getSystemConfigService() {
        return this.systemConfigService;
    }

    public final BaseModelService<U> getUserConfigService() {
        return this.userConfigService;
    }
}

