/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.base.BaseModel;
import cool.scx.data.jdbc.ColumnFilter;
import cool.scx.data.jdbc.ColumnMapping;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.exception.EmptyUpdateColumnException;
import java.util.Arrays;
import java.util.Map;

public final class CRUDUpdateParam {
    public Map<String, Object> updateModel;
    public String[] needUpdateFieldNames;

    public <B extends BaseModel> B getBaseModel(Class<B> modelClass) {
        return CRUDHelper.mapToBaseModel(this.updateModel, modelClass);
    }

    public ColumnFilter getUpdateFilter(Class<? extends BaseModel> modelClass, Table<? extends ColumnMapping> scxDaoTableInfo) {
        if (this.needUpdateFieldNames == null) {
            return ColumnFilter.ofExcluded();
        }
        String[] legalFieldName = (String[])Arrays.stream(this.needUpdateFieldNames).map(fieldName -> CRUDHelper.checkFieldName(modelClass, fieldName)).toArray(String[]::new);
        ColumnFilter updateFilter = ColumnFilter.ofIncluded((boolean)false).addIncluded(legalFieldName);
        if (updateFilter.filter(scxDaoTableInfo).length == 0) {
            throw new EmptyUpdateColumnException();
        }
        return updateFilter;
    }
}

