/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.base.BaseModel;
import cool.scx.core.base.BaseModelService;
import cool.scx.data.Query;
import cool.scx.data.jdbc.ColumnFilter;
import cool.scx.data.jdbc.ColumnMapping;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.data.query.Logic;
import cool.scx.data.query.WhereOption;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.CRUDListParam;
import cool.scx.ext.crud.CRUDListResult;
import cool.scx.ext.crud.CRUDUpdateParam;
import java.util.List;
import java.util.Map;

public interface CRUDHandler {
    default public boolean checkUnique(String modelName, String fieldName, Object value, Long id) {
        Class<BaseModel> baseModelClass = CRUDHelper.getCRUDApiInfo((String)modelName).baseModelClass;
        CRUDHelper.checkFieldName(baseModelClass, fieldName);
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        Query query = new Query().where(new Object[]{Logic.andSet().equal(fieldName, value, new WhereOption[0]).notEqual("id", (Object)id, new WhereOption[]{WhereOption.SKIP_IF_NULL})});
        return baseModelService.count(query) == 0L;
    }

    default public long batchDelete(String modelName, long[] deleteIDs) {
        Class<BaseModel> baseModelClass = CRUDHelper.getCRUDApiInfo((String)modelName).baseModelClass;
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        return baseModelService.delete(deleteIDs);
    }

    default public boolean delete(String modelName, Long id) {
        Class<BaseModel> baseModelClass = CRUDHelper.getCRUDApiInfo((String)modelName).baseModelClass;
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        return baseModelService.delete(new long[]{id}) == 1L;
    }

    default public BaseModel update(String modelName, CRUDUpdateParam crudUpdateParam) {
        Class<BaseModel> baseModelClass = CRUDHelper.getCRUDApiInfo((String)modelName).baseModelClass;
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        BaseModel realObject = crudUpdateParam.getBaseModel(baseModelClass);
        ColumnFilter updateFilter = crudUpdateParam.getUpdateFilter(baseModelClass, (Table<? extends ColumnMapping>)baseModelService._dao()._tableInfo());
        return baseModelService.update(realObject, updateFilter);
    }

    default public BaseModel add(String modelName, Map<String, Object> saveModel) {
        Class<BaseModel> baseModelClass = CRUDHelper.getCRUDApiInfo((String)modelName).baseModelClass;
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        BaseModel realObject = CRUDHelper.mapToBaseModel(saveModel, baseModelClass);
        return baseModelService.add(realObject);
    }

    default public BaseModel info(String modelName, Long id) {
        Class<BaseModel> baseModelClass = CRUDHelper.getCRUDApiInfo((String)modelName).baseModelClass;
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        return baseModelService.get(id.longValue());
    }

    default public CRUDListResult list(String modelName, CRUDListParam crudListParam) {
        Class<BaseModel> baseModelClass = CRUDHelper.getCRUDApiInfo((String)modelName).baseModelClass;
        BaseModelService<BaseModel> baseModelService = CRUDHelper.getBaseModelService(baseModelClass);
        Query query = crudListParam.getQueryOrThrow(baseModelClass);
        ColumnFilter selectFilter = crudListParam.getSelectFilterOrThrow(baseModelClass, (Table<? extends ColumnMapping>)baseModelService._dao()._tableInfo());
        List list = baseModelService.list(query, selectFilter);
        long total = baseModelService.count(query);
        return new CRUDListResult(list, total);
    }
}

