/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.base.BaseModel;
import cool.scx.data.Query;
import cool.scx.data.jdbc.ColumnFilter;
import cool.scx.data.jdbc.ColumnMapping;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.data.query.Limit;
import cool.scx.data.query.Logic;
import cool.scx.data.query.OrderByBody;
import cool.scx.data.query.OrderByOption;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.WhereBodySet;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.exception.EmptySelectColumnException;
import cool.scx.ext.crud.exception.PaginationParametersErrorException;
import cool.scx.ext.crud.exception.UnknownFilterModeException;
import cool.scx.ext.crud.exception.UnknownSortTypeException;
import cool.scx.ext.crud.exception.UnknownWhereTypeException;
import cool.scx.ext.crud.exception.WhereBodyParametersSizeErrorException;
import cool.scx.mvc.exception.BadRequestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public final class CRUDListParam {
    public CRUDPagination pagination;
    public List<CRUDOrderByBody> orderByBodyList;
    public List<CRUDWhereBody> whereBodyList;
    public CRUDSelectFilterBody selectFilterBody;

    public static WhereType checkWhereType(String fieldName, String strWhereType) throws UnknownWhereTypeException {
        try {
            return WhereType.of((String)strWhereType);
        }
        catch (Exception ignored) {
            throw new UnknownWhereTypeException(fieldName, strWhereType);
        }
    }

    public static OrderByType checkSortType(String fieldName, String strSortType) throws UnknownSortTypeException {
        try {
            return OrderByType.of((String)strSortType);
        }
        catch (Exception ignored) {
            throw new UnknownSortTypeException(fieldName, strSortType);
        }
    }

    public static void checkWhereBodyParametersSize(String fieldName, WhereType whereType, Object value1, Object value2) throws WhereBodyParametersSizeErrorException {
        AtomicInteger paramSize = new AtomicInteger();
        if (value1 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (value2 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (whereType.paramSize() != paramSize.get()) {
            throw new WhereBodyParametersSizeErrorException(fieldName, whereType, paramSize.get());
        }
    }

    public static ColumnFilter.FilterMode checkFilterMode(String filterMode) throws UnknownWhereTypeException {
        try {
            return ColumnFilter.FilterMode.of((String)filterMode);
        }
        catch (Exception ignored) {
            throw new UnknownFilterModeException(filterMode);
        }
    }

    public static Limit checkPagination(CRUDPagination crudPagination) {
        Long pageSize = crudPagination.pageSize;
        Long currentPage = crudPagination.currentPage;
        if (pageSize == null) {
            return new Limit();
        }
        if (pageSize < 0L) {
            throw new PaginationParametersErrorException(currentPage, pageSize);
        }
        if (currentPage == null) {
            return new Limit().limit(pageSize.longValue());
        }
        if (currentPage < 0L) {
            throw new PaginationParametersErrorException(currentPage, pageSize);
        }
        return new Limit().offset(currentPage * pageSize).limit(pageSize.longValue());
    }

    public Limit getLimit() {
        if (this.pagination != null) {
            try {
                return CRUDListParam.checkPagination(this.pagination);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Limit();
    }

    public Limit getLimitOrThrow() {
        if (this.pagination != null) {
            return CRUDListParam.checkPagination(this.pagination);
        }
        return new Limit();
    }

    public OrderByBody[] getOrderByClauses(Class<? extends BaseModel> modelClass) {
        ArrayList<OrderByBody> l = new ArrayList<OrderByBody>();
        if (this.orderByBodyList != null) {
            for (CRUDOrderByBody orderByBody : this.orderByBodyList) {
                if (orderByBody.fieldName == null || orderByBody.sortType == null) continue;
                try {
                    CRUDHelper.checkFieldName(modelClass, orderByBody.fieldName);
                    OrderByType sortType = CRUDListParam.checkSortType(orderByBody.fieldName, orderByBody.sortType);
                    l.add(OrderByBody.of((String)orderByBody.fieldName, (OrderByType)sortType, (OrderByOption[])new OrderByOption[0]));
                }
                catch (Exception exception) {}
            }
        }
        return (OrderByBody[])l.toArray(OrderByBody[]::new);
    }

    public OrderByBody[] getOrderByClausesOrThrow(Class<? extends BaseModel> modelClass) {
        ArrayList<OrderByBody> l = new ArrayList<OrderByBody>();
        if (this.orderByBodyList != null) {
            for (CRUDOrderByBody orderByBody : this.orderByBodyList) {
                if (orderByBody.fieldName == null || orderByBody.sortType == null) continue;
                CRUDHelper.checkFieldName(modelClass, orderByBody.fieldName);
                OrderByType sortType = CRUDListParam.checkSortType(orderByBody.fieldName, orderByBody.sortType);
                l.add(OrderByBody.of((String)orderByBody.fieldName, (OrderByType)sortType, (OrderByOption[])new OrderByOption[0]));
            }
        }
        return (OrderByBody[])l.toArray(OrderByBody[]::new);
    }

    public WhereBodySet getWhereBodySet(Class<? extends BaseModel> modelClass) {
        WhereBodySet l = Logic.andSet();
        if (this.whereBodyList != null) {
            for (CRUDWhereBody crudWhereBody : this.whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                try {
                    CRUDHelper.checkFieldName(modelClass, crudWhereBody.fieldName);
                    WhereType whereType = CRUDListParam.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                    CRUDListParam.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                    if (whereType.paramSize() == 0) {
                        l.add0(crudWhereBody.fieldName, whereType, new WhereOption[0]);
                        continue;
                    }
                    if (whereType.paramSize() == 1) {
                        l.add1(crudWhereBody.fieldName, whereType, crudWhereBody.value1, new WhereOption[0]);
                        continue;
                    }
                    if (whereType.paramSize() != 2) continue;
                    l.add2(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2, new WhereOption[0]);
                }
                catch (Exception exception) {}
            }
        }
        return l;
    }

    public WhereBodySet getWhereBodySetOrThrow(Class<? extends BaseModel> modelClass) {
        WhereBodySet l = Logic.andSet();
        if (this.whereBodyList != null) {
            for (CRUDWhereBody crudWhereBody : this.whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                CRUDHelper.checkFieldName(modelClass, crudWhereBody.fieldName);
                WhereType whereType = CRUDListParam.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                CRUDListParam.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                if (whereType.paramSize() == 0) {
                    l.add0(crudWhereBody.fieldName, whereType, new WhereOption[0]);
                    continue;
                }
                if (whereType.paramSize() == 1) {
                    l.add1(crudWhereBody.fieldName, whereType, crudWhereBody.value1, new WhereOption[0]);
                    continue;
                }
                if (whereType.paramSize() != 2) continue;
                l.add2(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2, new WhereOption[0]);
            }
        }
        return l;
    }

    public Query getQueryOrThrow(Class<? extends BaseModel> modelClass) throws BadRequestException {
        WhereBodySet whereBodySet = this.getWhereBodySetOrThrow(modelClass);
        OrderByBody[] orderByClauses = this.getOrderByClausesOrThrow(modelClass);
        Limit limit = this.getLimitOrThrow();
        Query query = new Query().where(new Object[]{whereBodySet}).groupBy(new Object[0]).orderBy(orderByClauses);
        if (limit.getOffset() != null) {
            query.offset(limit.getOffset().longValue());
        }
        if (limit.getLimit() != null) {
            query.limit(limit.getLimit().longValue());
        }
        return query;
    }

    public Query getQuery(Class<? extends BaseModel> modelClass) throws BadRequestException {
        WhereBodySet whereBodySet = this.getWhereBodySet(modelClass);
        OrderByBody[] orderByClauses = this.getOrderByClauses(modelClass);
        Limit limit = this.getLimit();
        Query query = new Query().where(new Object[]{whereBodySet}).groupBy(new Object[0]).orderBy(orderByClauses);
        if (limit.getOffset() != null) {
            query.offset(limit.getOffset().longValue());
        }
        if (limit.getLimit() != null) {
            query.limit(limit.getLimit().longValue());
        }
        return query;
    }

    public ColumnFilter getSelectFilterOrThrow(Class<? extends BaseModel> modelClass, Table<? extends ColumnMapping> scxDaoTableInfo) {
        ColumnFilter selectFilter;
        if (this.selectFilterBody == null) {
            return ColumnFilter.ofExcluded();
        }
        ColumnFilter.FilterMode filterMode = CRUDListParam.checkFilterMode(this.selectFilterBody.filterMode);
        String[] legalFieldName = this.selectFilterBody.fieldNames != null ? (String[])Arrays.stream(this.selectFilterBody.fieldNames).map(fieldName -> CRUDHelper.checkFieldName(modelClass, fieldName)).toArray(String[]::new) : new String[]{};
        switch (filterMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EXCLUDED: {
                ColumnFilter columnFilter = ColumnFilter.ofExcluded().addExcluded(legalFieldName);
                break;
            }
            case INCLUDED: {
                ColumnFilter columnFilter = selectFilter = ColumnFilter.ofIncluded().addIncluded(legalFieldName);
            }
        }
        if (selectFilter.filter(scxDaoTableInfo).length == 0) {
            throw new EmptySelectColumnException(filterMode, this.selectFilterBody.fieldNames);
        }
        return selectFilter;
    }

    public ColumnFilter getSelectFilter(Class<? extends BaseModel> modelClass, Table<? extends ColumnMapping> scxDaoTableInfo) {
        ColumnFilter selectFilter;
        String[] legalFieldName;
        if (this.selectFilterBody == null) {
            return ColumnFilter.ofExcluded();
        }
        ColumnFilter.FilterMode filterMode = CRUDListParam.checkFilterMode(this.selectFilterBody.filterMode);
        if (this.selectFilterBody.fieldNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String fieldName : this.selectFilterBody.fieldNames) {
                try {
                    list.add(CRUDHelper.checkFieldName(modelClass, fieldName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            legalFieldName = list.toArray(new String[0]);
        } else {
            legalFieldName = new String[]{};
        }
        switch (filterMode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case EXCLUDED: {
                ColumnFilter columnFilter = ColumnFilter.ofExcluded().addExcluded(legalFieldName);
                break;
            }
            case INCLUDED: {
                ColumnFilter columnFilter = selectFilter = ColumnFilter.ofIncluded().addIncluded(legalFieldName);
            }
        }
        if (selectFilter.filter(scxDaoTableInfo).length == 0) {
            throw new EmptySelectColumnException(filterMode, this.selectFilterBody.fieldNames);
        }
        return selectFilter;
    }

    public static final class CRUDPagination {
        public Long currentPage;
        public Long pageSize;
    }

    public static final class CRUDOrderByBody {
        public String fieldName;
        public String sortType;
    }

    public static final class CRUDWhereBody {
        public String fieldName;
        public String whereType;
        public Object value1;
        public Object value2;

        public CRUDWhereBody() {
        }

        public CRUDWhereBody(String fieldName, String whereType, Object value1, Object value2) {
            this.fieldName = fieldName;
            this.whereType = whereType;
            this.value1 = value1;
            this.value2 = value2;
        }
    }

    public static final class CRUDSelectFilterBody {
        public String filterMode;
        public String[] fieldNames;
    }
}

