/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.base.BaseModel;
import cool.scx.data.FieldFilter;
import cool.scx.data.jdbc.ColumnMapping;
import cool.scx.data.jdbc.FieldFilterHelper;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.exception.EmptyUpdateColumnException;
import java.util.Arrays;
import java.util.Map;

public final class CRUDUpdateParam {
    public Map<String, Object> updateModel;
    public String[] needUpdateFieldNames;

    public <B extends BaseModel> B getBaseModel(Class<B> modelClass) {
        return CRUDHelper.mapToBaseModel(this.updateModel, modelClass);
    }

    public FieldFilter getUpdateFilter(Class<? extends BaseModel> modelClass, Table<? extends ColumnMapping> scxDaoTableInfo) {
        if (this.needUpdateFieldNames == null) {
            return FieldFilter.ofExcluded((String[])new String[0]);
        }
        String[] legalFieldName = (String[])Arrays.stream(this.needUpdateFieldNames).map(fieldName -> CRUDHelper.checkFieldName(modelClass, fieldName)).toArray(String[]::new);
        FieldFilter updateFilter = FieldFilter.ofIncluded((String[])legalFieldName).excludeIfFieldValueIsNull(false);
        if (FieldFilterHelper.filter((FieldFilter)updateFilter, scxDaoTableInfo).length == 0) {
            throw new EmptyUpdateColumnException();
        }
        return updateFilter;
    }
}

