/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.core.base.BaseModel;
import cool.scx.data.FieldFilter;
import cool.scx.data.Query;
import cool.scx.data.QueryBuilder;
import cool.scx.data.field_filter.FilterMode;
import cool.scx.data.jdbc.ColumnMapping;
import cool.scx.data.jdbc.FieldFilterHelper;
import cool.scx.data.jdbc.mapping.Table;
import cool.scx.data.query.LimitInfo;
import cool.scx.data.query.OrderByBody;
import cool.scx.data.query.OrderByOption;
import cool.scx.data.query.OrderByType;
import cool.scx.data.query.WhereBodySet;
import cool.scx.data.query.WhereOption;
import cool.scx.data.query.WhereType;
import cool.scx.ext.crud.CRUDHelper;
import cool.scx.ext.crud.exception.EmptySelectColumnException;
import cool.scx.ext.crud.exception.PaginationParametersErrorException;
import cool.scx.ext.crud.exception.UnknownFilterModeException;
import cool.scx.ext.crud.exception.UnknownSortTypeException;
import cool.scx.ext.crud.exception.UnknownWhereTypeException;
import cool.scx.ext.crud.exception.WhereBodyParametersSizeErrorException;
import cool.scx.mvc.exception.BadRequestException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;

public final class CRUDListParam {
    public CRUDPagination pagination;
    public List<CRUDOrderByBody> orderByBodyList;
    public List<CRUDWhereBody> whereBodyList;
    public CRUDSelectFilterBody selectFilterBody;
    public Map<String, Object> extParams;

    public static WhereType checkWhereType(String fieldName, String strWhereType) throws UnknownWhereTypeException {
        try {
            return WhereType.of((String)strWhereType);
        }
        catch (Exception ignored) {
            throw new UnknownWhereTypeException(fieldName, strWhereType);
        }
    }

    public static OrderByType checkSortType(String fieldName, String strSortType) throws UnknownSortTypeException {
        try {
            return OrderByType.of((String)strSortType);
        }
        catch (Exception ignored) {
            throw new UnknownSortTypeException(fieldName, strSortType);
        }
    }

    public static void checkWhereBodyParametersSize(String fieldName, WhereType whereType, Object value1, Object value2) throws WhereBodyParametersSizeErrorException {
        AtomicInteger paramSize = new AtomicInteger();
        if (value1 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (value2 != null) {
            paramSize.set(paramSize.get() + 1);
        }
        if (whereType.paramSize() != paramSize.get()) {
            throw new WhereBodyParametersSizeErrorException(fieldName, whereType, paramSize.get());
        }
    }

    public static FilterMode checkFilterMode(String filterMode) throws UnknownWhereTypeException {
        try {
            return FilterMode.of((String)filterMode);
        }
        catch (Exception ignored) {
            throw new UnknownFilterModeException(filterMode);
        }
    }

    public static LimitInfo checkPagination(CRUDPagination crudPagination) {
        Long pageSize = crudPagination.pageSize;
        Long currentPage = crudPagination.currentPage;
        if (pageSize == null) {
            return new LimitInfo();
        }
        if (pageSize < 0L) {
            throw new PaginationParametersErrorException(currentPage, pageSize);
        }
        if (currentPage == null) {
            return new LimitInfo().limit(pageSize.longValue());
        }
        if (currentPage < 0L) {
            throw new PaginationParametersErrorException(currentPage, pageSize);
        }
        return new LimitInfo().offset(currentPage * pageSize).limit(pageSize.longValue());
    }

    public LimitInfo getLimitInfo() {
        if (this.pagination != null) {
            try {
                return CRUDListParam.checkPagination(this.pagination);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new LimitInfo();
    }

    public LimitInfo getLimitInfoOrThrow() {
        if (this.pagination != null) {
            return CRUDListParam.checkPagination(this.pagination);
        }
        return new LimitInfo();
    }

    public OrderByBody[] getOrderByClauses(Class<? extends BaseModel> modelClass) {
        ArrayList<OrderByBody> l = new ArrayList<OrderByBody>();
        if (this.orderByBodyList != null) {
            for (CRUDOrderByBody orderByBody : this.orderByBodyList) {
                if (orderByBody.fieldName == null || orderByBody.sortType == null) continue;
                try {
                    CRUDHelper.checkFieldName(modelClass, orderByBody.fieldName);
                    OrderByType sortType = CRUDListParam.checkSortType(orderByBody.fieldName, orderByBody.sortType);
                    l.add(new OrderByBody(orderByBody.fieldName, sortType, new OrderByOption[0]));
                }
                catch (Exception exception) {}
            }
        }
        return (OrderByBody[])l.toArray(OrderByBody[]::new);
    }

    public OrderByBody[] getOrderByClausesOrThrow(Class<? extends BaseModel> modelClass) {
        ArrayList<OrderByBody> l = new ArrayList<OrderByBody>();
        if (this.orderByBodyList != null) {
            for (CRUDOrderByBody orderByBody : this.orderByBodyList) {
                if (orderByBody.fieldName == null || orderByBody.sortType == null) continue;
                CRUDHelper.checkFieldName(modelClass, orderByBody.fieldName);
                OrderByType sortType = CRUDListParam.checkSortType(orderByBody.fieldName, orderByBody.sortType);
                l.add(new OrderByBody(orderByBody.fieldName, sortType, new OrderByOption[0]));
            }
        }
        return (OrderByBody[])l.toArray(OrderByBody[]::new);
    }

    public WhereBodySet getWhereBodySet(Class<? extends BaseModel> modelClass) {
        WhereBodySet l = QueryBuilder.andSet();
        if (this.whereBodyList != null) {
            for (CRUDWhereBody crudWhereBody : this.whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                try {
                    CRUDHelper.checkFieldName(modelClass, crudWhereBody.fieldName);
                    WhereType whereType = CRUDListParam.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                    CRUDListParam.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                    if (whereType.paramSize() == 0) {
                        l.add0(crudWhereBody.fieldName, whereType, new WhereOption[0]);
                        continue;
                    }
                    if (whereType.paramSize() == 1) {
                        l.add1(crudWhereBody.fieldName, whereType, crudWhereBody.value1, new WhereOption[0]);
                        continue;
                    }
                    if (whereType.paramSize() != 2) continue;
                    l.add2(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2, new WhereOption[0]);
                }
                catch (Exception exception) {}
            }
        }
        return l;
    }

    public WhereBodySet getWhereBodySetOrThrow(Class<? extends BaseModel> modelClass) {
        WhereBodySet l = QueryBuilder.andSet();
        if (this.whereBodyList != null) {
            for (CRUDWhereBody crudWhereBody : this.whereBodyList) {
                if (crudWhereBody.fieldName == null || crudWhereBody.whereType == null) continue;
                CRUDHelper.checkFieldName(modelClass, crudWhereBody.fieldName);
                WhereType whereType = CRUDListParam.checkWhereType(crudWhereBody.fieldName, crudWhereBody.whereType);
                CRUDListParam.checkWhereBodyParametersSize(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2);
                if (whereType.paramSize() == 0) {
                    l.add0(crudWhereBody.fieldName, whereType, new WhereOption[0]);
                    continue;
                }
                if (whereType.paramSize() == 1) {
                    l.add1(crudWhereBody.fieldName, whereType, crudWhereBody.value1, new WhereOption[0]);
                    continue;
                }
                if (whereType.paramSize() != 2) continue;
                l.add2(crudWhereBody.fieldName, whereType, crudWhereBody.value1, crudWhereBody.value2, new WhereOption[0]);
            }
        }
        return l;
    }

    public Query getQueryOrThrow(Class<? extends BaseModel> modelClass) throws BadRequestException {
        WhereBodySet whereBodySet = this.getWhereBodySetOrThrow(modelClass);
        OrderByBody[] orderByClauses = this.getOrderByClausesOrThrow(modelClass);
        LimitInfo limit = this.getLimitInfoOrThrow();
        Query query = QueryBuilder.query().where(new Object[]{whereBodySet}).groupBy(new Object[0]).orderBy((Object[])orderByClauses);
        if (limit.getOffset() != null) {
            query.offset(limit.getOffset().longValue());
        }
        if (limit.getLimit() != null) {
            query.limit(limit.getLimit().longValue());
        }
        return query;
    }

    public Query getQuery(Class<? extends BaseModel> modelClass) throws BadRequestException {
        WhereBodySet whereBodySet = this.getWhereBodySet(modelClass);
        OrderByBody[] orderByClauses = this.getOrderByClauses(modelClass);
        LimitInfo limit = this.getLimitInfo();
        Query query = QueryBuilder.query().where(new Object[]{whereBodySet}).groupBy(new Object[0]).orderBy((Object[])orderByClauses);
        if (limit.getOffset() != null) {
            query.offset(limit.getOffset().longValue());
        }
        if (limit.getLimit() != null) {
            query.limit(limit.getLimit().longValue());
        }
        return query;
    }

    public FieldFilter getSelectFilterOrThrow(Class<? extends BaseModel> modelClass, Table<? extends ColumnMapping> scxDaoTableInfo) {
        FieldFilter selectFilter;
        if (this.selectFilterBody == null) {
            return FieldFilter.ofExcluded((String[])new String[0]);
        }
        FilterMode filterMode = CRUDListParam.checkFilterMode(this.selectFilterBody.filterMode);
        String[] legalFieldName = this.selectFilterBody.fieldNames != null ? (String[])Arrays.stream(this.selectFilterBody.fieldNames).map(fieldName -> CRUDHelper.checkFieldName(modelClass, fieldName)).toArray(String[]::new) : new String[]{};
        switch (filterMode) {
            default: {
                throw new MatchException(null, null);
            }
            case EXCLUDED: {
                FieldFilter fieldFilter = FieldFilter.ofExcluded((String[])legalFieldName);
                break;
            }
            case INCLUDED: {
                FieldFilter fieldFilter = selectFilter = FieldFilter.ofIncluded((String[])legalFieldName);
            }
        }
        if (FieldFilterHelper.filter((FieldFilter)selectFilter, scxDaoTableInfo).length == 0) {
            throw new EmptySelectColumnException(filterMode, this.selectFilterBody.fieldNames);
        }
        return selectFilter;
    }

    public FieldFilter getSelectFilter(Class<? extends BaseModel> modelClass, Table<? extends ColumnMapping> scxDaoTableInfo) {
        FieldFilter selectFilter;
        String[] legalFieldName;
        if (this.selectFilterBody == null) {
            return FieldFilter.ofExcluded((String[])new String[0]);
        }
        FilterMode filterMode = CRUDListParam.checkFilterMode(this.selectFilterBody.filterMode);
        if (this.selectFilterBody.fieldNames != null) {
            ArrayList<String> list = new ArrayList<String>();
            for (String fieldName : this.selectFilterBody.fieldNames) {
                try {
                    list.add(CRUDHelper.checkFieldName(modelClass, fieldName));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            legalFieldName = list.toArray(new String[0]);
        } else {
            legalFieldName = new String[]{};
        }
        switch (filterMode) {
            default: {
                throw new MatchException(null, null);
            }
            case EXCLUDED: {
                FieldFilter fieldFilter = FieldFilter.ofExcluded((String[])legalFieldName);
                break;
            }
            case INCLUDED: {
                FieldFilter fieldFilter = selectFilter = FieldFilter.ofIncluded((String[])legalFieldName);
            }
        }
        if (FieldFilterHelper.filter((FieldFilter)selectFilter, scxDaoTableInfo).length == 0) {
            throw new EmptySelectColumnException(filterMode, this.selectFilterBody.fieldNames);
        }
        return selectFilter;
    }

    public static final class CRUDPagination {
        public Long currentPage;
        public Long pageSize;
    }

    public static final class CRUDOrderByBody {
        public String fieldName;
        public String sortType;
    }

    public static final class CRUDWhereBody {
        public String fieldName;
        public String whereType;
        public Object value1;
        public Object value2;

        public CRUDWhereBody() {
        }

        public CRUDWhereBody(String fieldName, String whereType, Object value1, Object value2) {
            this.fieldName = fieldName;
            this.whereType = whereType;
            this.value1 = value1;
            this.value2 = value2;
        }
    }

    public static final class CRUDSelectFilterBody {
        public String filterMode;
        public String[] fieldNames;
    }
}

