/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.common.util.ObjectUtils;
import cool.scx.core.base.BaseModel;
import cool.scx.data.jdbc.annotation.NoColumn;
import cool.scx.ext.crud.exception.UnknownFieldNameException;
import cool.scx.mvc.exception.BadRequestException;
import java.lang.reflect.Field;
import java.util.Map;

public final class CRUDHelper {
    private static final System.Logger logger = System.getLogger(CRUDHelper.class.getName());

    public static <B extends BaseModel> B mapToBaseModel(Map<String, Object> map, Class<B> baseModelClass) {
        try {
            return (B)((BaseModel)ObjectUtils.convertValue(map, baseModelClass, (ObjectUtils.Option[])new ObjectUtils.Option[]{ObjectUtils.Option.IGNORE_JSON_IGNORE}));
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "\u5c06 Map \u8f6c\u6362\u4e3a BaseModel \u65f6\u53d1\u751f\u5f02\u5e38 : ", (Throwable)e);
            throw new BadRequestException((Throwable)e);
        }
    }

    public static String checkFieldName(Class<?> modelClass, String fieldName) throws UnknownFieldNameException {
        try {
            Field field = modelClass.getField(fieldName);
            if (field.isAnnotationPresent(NoColumn.class)) {
                throw new UnknownFieldNameException(fieldName);
            }
        }
        catch (Exception e) {
            throw new UnknownFieldNameException(fieldName);
        }
        return fieldName;
    }
}

