package cool.scx.ext.crud;

import cool.scx.common.util.ObjectUtils;
import cool.scx.core.base.BaseModel;
import cool.scx.data.jdbc.annotation.NoColumn;
import cool.scx.ext.crud.exception.UnknownFieldNameException;
import cool.scx.mvc.exception.BadRequestException;

import java.lang.System.Logger;
import java.util.Map;

import static java.lang.System.Logger.Level.ERROR;

/**
 * a
 *
 * @author scx567888
 * @version 1.7.7
 */
public final class CRUDHelper {

    /**
     * a
     */
    private static final Logger logger = System.getLogger(CRUDHelper.class.getName());

    /**
     * 获取 baseModel
     *
     * @param map            a
     * @param baseModelClass a
     * @param <B>            b
     * @return a
     */
    public static <B extends BaseModel> B mapToBaseModel(Map<String, Object> map, Class<B> baseModelClass) {
        try {
            return ObjectUtils.convertValue(map, baseModelClass, ObjectUtils.Option.IGNORE_JSON_IGNORE);
        } catch (Exception e) {
            logger.log(ERROR, "将 Map 转换为 BaseModel 时发生异常 : ", e);
            //这里一般就是 参数转换错误
            throw new BadRequestException(e);
        }
    }

    /**
     * 检查 fieldName 是否合法
     *
     * @param modelClass m
     * @param fieldName  f
     * @return a {@link String} object
     * @throws UnknownFieldNameException c
     */
    public static String checkFieldName(Class<?> modelClass, String fieldName) throws UnknownFieldNameException {
        try {
            var field = modelClass.getField(fieldName);
            if (field.isAnnotationPresent(NoColumn.class)) {
                throw new UnknownFieldNameException(fieldName);
            }
        } catch (Exception e) {
            throw new UnknownFieldNameException(fieldName);
        }
        return fieldName;
    }

}
