/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.fss;

import cool.scx.common.standard.HttpMethod;
import cool.scx.common.util.Cache;
import cool.scx.common.util.FileUtils;
import cool.scx.common.util.HashUtils;
import cool.scx.ext.fss.FSSConfig;
import cool.scx.ext.fss.FSSHelper;
import cool.scx.ext.fss.FSSObject;
import cool.scx.ext.fss.FSSObjectService;
import cool.scx.mvc.annotation.FromBody;
import cool.scx.mvc.annotation.FromPath;
import cool.scx.mvc.annotation.FromQuery;
import cool.scx.mvc.annotation.FromUpload;
import cool.scx.mvc.annotation.ScxRoute;
import cool.scx.mvc.exception.InternalServerErrorException;
import cool.scx.mvc.exception.NotFoundException;
import cool.scx.mvc.type.UploadedEntity;
import cool.scx.mvc.vo.BaseVo;
import cool.scx.mvc.vo.Download;
import cool.scx.mvc.vo.Image;
import cool.scx.mvc.vo.Raw;
import cool.scx.mvc.vo.Result;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.List;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;

@ScxRoute(value="/api/fss")
public class FSSController {
    private static final Cache<String, Image> IMAGE_CACHE = new Cache(10000);
    private final FSSObjectService fssObjectService;

    public FSSController(FSSObjectService fssObjectService) {
        this.fssObjectService = fssObjectService;
    }

    @ScxRoute(value="/download/:fssObjectID", methods={HttpMethod.GET, HttpMethod.HEAD})
    public Download download(@FromPath String fssObjectID) {
        FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
        Path file = FSSHelper.checkPhysicalFile(fssObject);
        return Download.of((Path)file, (String)fssObject.fileName);
    }

    @ScxRoute(value="/image/:fssObjectID", methods={HttpMethod.GET, HttpMethod.HEAD})
    public Image image(@FromPath String fssObjectID, @FromQuery(value="w", required=false) Integer width, @FromQuery(value="h", required=false) Integer height, @FromQuery(value="t", required=false) String type) {
        Positions positions = FSSHelper.getPositions(type);
        String cacheKey = fssObjectID + " " + width + " " + height + " " + String.valueOf(positions);
        return (Image)IMAGE_CACHE.computeIfAbsent((Object)cacheKey, k -> {
            FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
            Path file = FSSHelper.checkPhysicalFile(fssObject);
            return Image.of((File)file.toFile(), (Integer)width, (Integer)height, (Position)positions);
        });
    }

    @ScxRoute(value="/raw/:fssObjectID", methods={HttpMethod.GET, HttpMethod.HEAD})
    public Raw raw(@FromPath String fssObjectID) {
        FSSObject fssObject = this.checkFSSObjectID(fssObjectID);
        Path file = FSSHelper.checkPhysicalFile(fssObject);
        return Raw.of((Path)file);
    }

    @ScxRoute(value="/upload", methods={HttpMethod.POST})
    public BaseVo upload(@FromBody String fileName, @FromBody Long fileSize, @FromBody String fileHash, @FromBody Integer chunkLength, @FromBody Integer nowChunkIndex, @FromUpload UploadedEntity fileData) throws Exception {
        Path uploadTempFile = FSSHelper.getUploadTempPath(fileHash).resolve("scx_fss.temp");
        Path uploadConfigFile = uploadTempFile.resolveSibling("scx_fss.upload_state");
        if (nowChunkIndex == chunkLength - 1) {
            FileUtils.write((Path)uploadTempFile, (byte[])fileData.buffer().getBytes(), (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
            FSSObject newFSSObject = FSSHelper.createFSSObjectByFileInfo(fileName, fileSize, fileHash);
            Path fileStoragePath = Path.of(FSSConfig.uploadFilePath().toString(), newFSSObject.filePath);
            String serverHashStr = HashUtils.md5Hex((File)uploadTempFile.toFile());
            if (!fileHash.equalsIgnoreCase(serverHashStr)) {
                FileUtils.delete((Path)uploadTempFile.getParent(), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
                throw new InternalServerErrorException("\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25 : Hash \u6821\u9a8c\u5931\u8d25 , \u6587\u4ef6 : " + fileHash);
            }
            FileUtils.move((Path)uploadTempFile, (Path)fileStoragePath, (CopyOption[])new CopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            FileUtils.delete((Path)uploadTempFile.getParent(), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
            FSSObject save = (FSSObject)this.fssObjectService.add(newFSSObject);
            return Result.ok().put("type", (Object)"upload-success").put("item", (Object)save);
        }
        Integer lastUploadChunk = FSSHelper.getLastUploadChunk(uploadConfigFile, chunkLength);
        int needUploadChunkIndex = lastUploadChunk + 1;
        if (nowChunkIndex.equals(needUploadChunkIndex)) {
            FileUtils.write((Path)uploadTempFile, (byte[])fileData.buffer().getBytes(), (OpenOption[])new OpenOption[]{StandardOpenOption.APPEND, StandardOpenOption.CREATE, StandardOpenOption.SYNC, StandardOpenOption.WRITE});
            FSSHelper.updateLastUploadChunk(uploadConfigFile, nowChunkIndex, chunkLength);
            return Result.ok().put("type", (Object)"need-more").put("item", (Object)(needUploadChunkIndex + 1));
        }
        return Result.ok().put("type", (Object)"need-more").put("item", (Object)needUploadChunkIndex);
    }

    @ScxRoute(value="/delete", methods={HttpMethod.DELETE})
    public BaseVo delete(@FromBody String fssObjectID) throws IOException {
        this.fssObjectService.delete(fssObjectID);
        return Result.ok();
    }

    @ScxRoute(value="check-any-file-exists-by-hash", methods={HttpMethod.POST})
    public BaseVo checkAnyFileExistsByHash(@FromBody String fileName, @FromBody Long fileSize, @FromBody String fileHash) throws IOException {
        List<FSSObject> fssObjectListByHash = this.fssObjectService.findFSSObjectListByHash(fileHash);
        if (fssObjectListByHash.size() > 0) {
            FSSObject canUseFssObject = null;
            for (FSSObject fssObject : fssObjectListByHash) {
                File physicalFile = FSSHelper.getPhysicalFilePath(fssObject).toFile();
                if (!physicalFile.exists() || physicalFile.length() != fileSize.longValue() || !fileHash.equalsIgnoreCase(HashUtils.md5Hex((File)physicalFile))) continue;
                canUseFssObject = fssObject;
                break;
            }
            if (canUseFssObject != null) {
                FSSObject save = (FSSObject)this.fssObjectService.add(FSSHelper.copyFSSObject(fileName, canUseFssObject));
                FileUtils.delete((Path)FSSHelper.getUploadTempPath(fileHash), (FileUtils.DeleteOption[])new FileUtils.DeleteOption[0]);
                return Result.ok().put("type", (Object)"upload-by-hash-success").put("item", (Object)save);
            }
        }
        return Result.fail((String)"no-any-file-exists-for-hash");
    }

    @ScxRoute(value="/info", methods={HttpMethod.POST})
    public BaseVo info(@FromBody String fssObjectID) {
        if (fssObjectID != null) {
            return Result.ok((Object)((Object)this.fssObjectService.findByFSSObjectID(fssObjectID)));
        }
        return Result.ok(null);
    }

    @ScxRoute(value="/list-info", methods={HttpMethod.POST})
    public BaseVo listInfo(@FromBody List<String> fssObjectIDs) {
        if (fssObjectIDs != null && fssObjectIDs.size() > 0) {
            return Result.ok(this.fssObjectService.findByFSSObjectIDs(fssObjectIDs));
        }
        return Result.ok(new ArrayList());
    }

    private FSSObject checkFSSObjectID(String fssObjectID) {
        FSSObject fssObject = this.fssObjectService.findByFSSObjectID(fssObjectID);
        if (fssObject == null) {
            throw new NotFoundException();
        }
        return fssObject;
    }
}

