/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.redirects;

import cool.scx.common.util.ansi.Ansi;
import cool.scx.common.util.ansi.AnsiElement;
import cool.scx.core.Scx;
import cool.scx.core.ScxModule;
import cool.scx.mvc.vo.Redirections;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.web.Router;

public class RedirectsModule
extends ScxModule {
    private static final System.Logger logger = System.getLogger(RedirectsModule.class.getName());
    private final int port;

    public RedirectsModule() {
        this(80);
    }

    public RedirectsModule(int port) {
        this.port = port;
    }

    public static void startRedirects(Vertx vertx, int port) {
        Router router = Router.router((Vertx)vertx);
        router.route().handler(c -> {
            String oldURI = c.request().absoluteURI();
            String newURI = "https" + oldURI.substring(4);
            Redirections.ofTemporary((String)newURI).accept(c);
        });
        vertx.createHttpServer().requestHandler((Handler)router).listen(port, http -> {
            if (http.succeeded()) {
                Ansi.out().brightMagenta((Object)("\u8f6c\u53d1\u670d\u52a1\u5668\u542f\u52a8\u6210\u529f http -> https, \u7aef\u53e3\u53f7 : " + port + " !!!"), new AnsiElement[0]).println();
            } else {
                logger.log(System.Logger.Level.ERROR, "\u8f6c\u53d1\u670d\u52a1\u5668\u542f\u52a8\u5931\u8d25 !!! ", http.cause());
            }
        });
    }

    public String name() {
        return "SCX_EXT-" + super.name();
    }

    public void start(Scx scx) {
        if (scx.scxOptions().isHttpsEnabled()) {
            RedirectsModule.startRedirects(scx.vertx(), this.port);
        }
    }
}

