/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.ws;

import com.fasterxml.jackson.core.JsonProcessingException;
import cool.scx.ext.ws.WSContext;
import cool.scx.ext.ws.WSMessage;
import cool.scx.mvc.annotation.ScxWebSocketRoute;
import cool.scx.mvc.base.BaseWebSocketHandler;
import cool.scx.mvc.websocket.OnCloseRoutingContext;
import cool.scx.mvc.websocket.OnExceptionRoutingContext;
import cool.scx.mvc.websocket.OnFrameRoutingContext;
import cool.scx.mvc.websocket.OnOpenRoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ScxWebSocketRoute(value="/scx")
public class WSWebSocketHandler
implements BaseWebSocketHandler {
    public static final String LOVE = "\u2764";
    private static final Logger logger = LoggerFactory.getLogger(WSWebSocketHandler.class);

    public void onOpen(OnOpenRoutingContext ctx) {
        WSContext.wsOnlineClientTable().add(ctx.webSocket());
        logger.debug("{} \u8fde\u63a5\u4e86!!! \u5f53\u524d\u603b\u8fde\u63a5\u6570 : {}", (Object)ctx.webSocket().remoteAddress(), (Object)WSContext.wsOnlineClientTable().size());
        ctx.next();
    }

    public void onClose(OnCloseRoutingContext ctx) {
        WSContext.wsOnlineClientTable().remove(ctx.webSocket());
        logger.debug("{} \u5173\u95ed\u4e86!!! \u5f53\u524d\u603b\u8fde\u63a5\u6570 : {}", (Object)ctx.webSocket().remoteAddress(), (Object)WSContext.wsOnlineClientTable().size());
        ctx.next();
    }

    public void onTextMessage(OnFrameRoutingContext ctx) throws JsonProcessingException {
        if (LOVE.equals(ctx.textData())) {
            ctx.webSocket().writeTextMessage(LOVE);
        } else {
            WSContext.wsEventBus().publishByWSMessage(WSMessage.fromJson(ctx.textData()).setWebSocket(ctx.webSocket()));
        }
        ctx.next();
    }

    public void onError(OnExceptionRoutingContext ctx) {
        WSContext.wsOnlineClientTable().remove(ctx.webSocket());
        ctx.cause().printStackTrace();
        ctx.next();
    }
}

