/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.ws;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import cool.scx.core.eventbus.ZeroCopyMessage;
import cool.scx.util.ObjectUtils;
import io.vertx.core.http.ServerWebSocket;
import java.util.HashMap;
import java.util.Map;

@ZeroCopyMessage
public class WSMessage<T> {
    private String address;
    private Map<String, Object> headers;
    private T body;
    private String replyAddress;
    private ServerWebSocket webSocket;

    public WSMessage() {
    }

    public WSMessage(String address) {
        this.address = address;
    }

    public WSMessage(String address, T body) {
        this.address = address;
        this.body = body;
    }

    public WSMessage(String address, T body, Map<String, Object> headers) {
        this.address = address;
        this.body = body;
        this.headers = new HashMap<String, Object>(headers);
    }

    public static WSMessage<Object> fromJson(String json) throws JsonProcessingException {
        Map jsonNode = (Map)ObjectUtils.jsonMapper((ObjectUtils.Option[])new ObjectUtils.Option[0]).readValue(json, ObjectUtils.MAP_TYPE);
        WSMessage<Object> wsMessage = new WSMessage<Object>();
        wsMessage.address = (String)ObjectUtils.convertValue(jsonNode.get("address"), String.class, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        wsMessage.body = jsonNode.get("body");
        wsMessage.headers = (Map)ObjectUtils.convertValue(jsonNode.get("headers"), (TypeReference)ObjectUtils.MAP_TYPE, (ObjectUtils.Option[])new ObjectUtils.Option[0]);
        return wsMessage;
    }

    public String toJson() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("address", this.address);
        map.put("body", this.body);
        map.put("headers", this.headers);
        return ObjectUtils.toJson(map, (String)"", (ObjectUtils.Option[])new ObjectUtils.Option[0]);
    }

    public String address() {
        return this.address;
    }

    public T body() {
        return this.body;
    }

    WSMessage<T> setWebSocket(ServerWebSocket webSocket) {
        this.webSocket = webSocket;
        return this;
    }

    public ServerWebSocket webSocket() {
        return this.webSocket;
    }
}

