package cool.scx.ext.crud;

import cool.scx.exception.HttpRequestException;
import cool.scx.vo.Json;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public interface CRUDHandler {
    Json checkUnique(String modelName, Map<String, Object> params) throws HttpRequestException, SQLException;

    Json getAutoComplete(String modelName, String fieldName) throws HttpRequestException, SQLException;

    Json revokeDelete(String modelName, Integer id) throws HttpRequestException, SQLException;

    Json batchDelete(String modelName, long[] deleteIds) throws HttpRequestException, SQLException;

    Json delete(String modelName, Integer id) throws HttpRequestException, SQLException;

    Json update(String modelName, Map<String, Object> entityMap) throws HttpRequestException, SQLException;

    Json save(String modelName, Map<String, Object> entityMap) throws HttpRequestException, SQLException;

    Json info(String modelName, Long id) throws HttpRequestException, SQLException;

    Json list(String modelName, Integer limit, Integer page, String orderByColumn, String sortType, List<CrudWhereBody> whereBodyList) throws HttpRequestException, SQLException;
}
