/*
 * Decompiled with CFR 0.152.
 */
package cool.scx.ext.crud;

import cool.scx.Scx;
import cool.scx.ScxContext;
import cool.scx.annotation.FromBody;
import cool.scx.annotation.FromPath;
import cool.scx.annotation.ScxMapping;
import cool.scx.enumeration.Method;
import cool.scx.exception.HttpRequestException;
import cool.scx.ext.crud.CRUDHandler;
import cool.scx.ext.crud.CRUDModule;
import cool.scx.ext.crud.CrudWhereBody;
import cool.scx.ext.organization.auth.OrganizationPerms;
import cool.scx.vo.Json;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

@ScxMapping(value="api/crud")
public class CRUDController {
    private final CRUDHandler crudHandler;

    public CRUDController() {
        Class<? extends CRUDHandler> crudHandlerClass = ((CRUDModule)Scx.getScxModuleByBaseModuleClass(CRUDModule.class).baseModuleExample()).crudHandlerClass();
        this.crudHandler = (CRUDHandler)ScxContext.getBean(crudHandlerClass);
    }

    @OrganizationPerms(checkedLogin=true)
    @ScxMapping(value=":modelName/list", method={Method.POST})
    public Json list(@FromPath String modelName, @FromBody(value="pagination.limit", required=false) Integer limit, @FromBody(value="pagination.page", required=false) Integer page, @FromBody(value="orderBy.orderByColumn", required=false) String orderByColumn, @FromBody(value="orderBy.sortType", required=false) String sortType, @FromBody(value="whereBodyList", required=false) List<CrudWhereBody> whereBodyList) throws HttpRequestException, SQLException {
        return this.crudHandler.list(modelName, limit, page, orderByColumn, sortType, whereBodyList);
    }

    @OrganizationPerms(checkedLogin=true)
    @ScxMapping(value=":modelName/:id", method={Method.GET})
    public Json info(String modelName, Long id) throws HttpRequestException, SQLException {
        return this.crudHandler.info(modelName, id);
    }

    @OrganizationPerms(checkedLogin=true)
    @ScxMapping(value=":modelName", method={Method.POST})
    public Json save(String modelName, Map<String, Object> entityMap) throws HttpRequestException, SQLException {
        return this.crudHandler.save(modelName, entityMap);
    }

    @OrganizationPerms(checkedLogin=true)
    @ScxMapping(value=":modelName", method={Method.PUT})
    public Json update(String modelName, Map<String, Object> entityMap) throws HttpRequestException, SQLException {
        return this.crudHandler.update(modelName, entityMap);
    }

    @OrganizationPerms(checkedLogin=true)
    @ScxMapping(value=":modelName/:id", method={Method.DELETE})
    public Json delete(String modelName, Integer id) throws HttpRequestException, SQLException {
        return this.crudHandler.delete(modelName, id);
    }

    @OrganizationPerms(checkedLogin=true)
    @ScxMapping(value=":modelName/batch-delete", method={Method.DELETE})
    public Json batchDelete(String modelName, @FromBody(value="deleteIds") long[] deleteIds) throws HttpRequestException, SQLException {
        return this.crudHandler.batchDelete(modelName, deleteIds);
    }

    @ScxMapping(value=":modelName/revoke-delete/:id", method={Method.GET})
    public Json revokeDelete(String modelName, Integer id) throws HttpRequestException, SQLException {
        return this.crudHandler.revokeDelete(modelName, id);
    }

    @ScxMapping(value=":modelName/get-auto-complete/:fieldName", method={Method.POST})
    public Json getAutoComplete(String modelName, String fieldName) throws HttpRequestException, SQLException {
        return this.crudHandler.getAutoComplete(modelName, fieldName);
    }

    @ScxMapping(value=":modelName/check-unique", method={Method.POST})
    public Json checkUnique(String modelName, Map<String, Object> params) throws HttpRequestException, SQLException {
        return this.crudHandler.checkUnique(modelName, params);
    }
}

